/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.plugin;

import java.util.List;
import org.gradle.mvn3.org.apache.maven.plugin.PluginConfigurationException;
import org.gradle.mvn3.org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.gradle.mvn3.org.apache.maven.plugin.descriptor.Parameter;
import org.gradle.mvn3.org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginParameterException
extends PluginConfigurationException {
    private final List<Parameter> parameters;
    private final MojoDescriptor mojo;

    public PluginParameterException(MojoDescriptor mojo, List<Parameter> parameters) {
        super(mojo.getPluginDescriptor(), "The parameters " + PluginParameterException.format(parameters) + " for goal " + mojo.getRoleHint() + " are missing or invalid");
        this.mojo = mojo;
        this.parameters = parameters;
    }

    private static String format(List<Parameter> parameters) {
        StringBuilder buffer = new StringBuilder(128);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'').append(parameter.getName()).append('\'');
            }
        }
        return buffer.toString();
    }

    public MojoDescriptor getMojoDescriptor() {
        return this.mojo;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private static void decomposeParameterIntoUserInstructions(MojoDescriptor mojo, Parameter param, StringBuilder messageBuffer) {
        String expression = param.getExpression();
        if (param.isEditable()) {
            messageBuffer.append("Inside the definition for plugin '" + mojo.getPluginDescriptor().getArtifactId() + "' specify the following:\n\n<configuration>\n  ...\n  <" + param.getName() + ">VALUE</" + param.getName() + ">\n</configuration>");
            String alias = param.getAlias();
            if (StringUtils.isNotEmpty((String)alias) && !alias.equals(param.getName())) {
                messageBuffer.append("\n\n-OR-\n\n<configuration>\n  ...\n  <" + alias + ">VALUE</" + alias + ">\n</configuration>\n");
            }
        }
        if (StringUtils.isEmpty((String)expression)) {
            messageBuffer.append(".");
        } else if (param.isEditable()) {
            messageBuffer.append("\n\n-OR-\n\n");
        }
    }

    public String buildDiagnosticMessage() {
        StringBuilder messageBuffer = new StringBuilder(256);
        List<Parameter> params = this.getParameters();
        MojoDescriptor mojo = this.getMojoDescriptor();
        messageBuffer.append("One or more required plugin parameters are invalid/missing for '").append(mojo.getPluginDescriptor().getGoalPrefix()).append(":").append(mojo.getGoal()).append("'\n");
        int idx = 0;
        for (Parameter param : params) {
            messageBuffer.append("\n[").append(idx).append("] ");
            PluginParameterException.decomposeParameterIntoUserInstructions(mojo, param, messageBuffer);
            messageBuffer.append("\n");
            ++idx;
        }
        return messageBuffer.toString();
    }
}

