/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.plugin.internal;

import org.gradle.mvn3.org.sonatype.aether.RepositoryException;
import org.gradle.mvn3.org.sonatype.aether.artifact.Artifact;
import org.gradle.mvn3.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.gradle.mvn3.org.sonatype.aether.collection.DependencyGraphTransformer;
import org.gradle.mvn3.org.sonatype.aether.graph.Dependency;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyNode;
import org.gradle.mvn3.org.sonatype.aether.util.artifact.DefaultArtifact;
import org.gradle.mvn3.org.sonatype.aether.util.graph.DefaultDependencyNode;

class PlexusUtilsInjector
implements DependencyGraphTransformer {
    private static final String GID = "org.gradle.mvn3.org.codehaus.plexus";
    private static final String AID = "plexus-utils";
    private static final String VER = "1.1";
    private static final String EXT = "jar";

    PlexusUtilsInjector() {
    }

    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        if (this.findPlexusUtils(node) == null) {
            DefaultArtifact pu = new DefaultArtifact(GID, AID, null, EXT, VER);
            DefaultDependencyNode child = new DefaultDependencyNode(new Dependency((Artifact)pu, "runtime"));
            child.setRepositories(node.getRepositories());
            child.setRequestContext(node.getRequestContext());
            node.getChildren().add(child);
        }
        return node;
    }

    private DependencyNode findPlexusUtils(DependencyNode node) {
        Artifact artifact = node.getDependency().getArtifact();
        if (AID.equals(artifact.getArtifactId()) && GID.equals(artifact.getGroupId()) && EXT.equals(artifact.getExtension()) && "".equals(artifact.getClassifier())) {
            return node;
        }
        for (DependencyNode child : node.getChildren()) {
            DependencyNode result = this.findPlexusUtils(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

