/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import java.io.File;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.JvmBinaryTasks;
import org.gradle.jvm.internal.DefaultJvmBinaryTasks;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.platform.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassDirectoryBinarySpec
extends AbstractBuildableModelElement
implements ClassDirectoryBinarySpecInternal {
    private final BinaryNamingScheme namingScheme;
    private final LanguageSourceSetContainer source = new LanguageSourceSetContainer();
    private final String name;
    private final JavaToolChain toolChain;
    private final JavaPlatform platform;
    private final DefaultJvmBinaryTasks tasks = new DefaultJvmBinaryTasks((JvmBinarySpec)this);
    private File classesDir;
    private File resourcesDir;

    public DefaultClassDirectoryBinarySpec(String name, JavaToolChain toolChain, JavaPlatform platform) {
        this.name = name;
        this.toolChain = toolChain;
        this.platform = platform;
        this.namingScheme = new ClassDirectoryBinaryNamingScheme(this.removeClassesSuffix(name));
    }

    private String removeClassesSuffix(String name) {
        if (name.endsWith("Classes")) {
            return name.substring(0, name.length() - 7);
        }
        return name;
    }

    public JvmBinaryTasks getTasks() {
        return this.tasks;
    }

    public JavaToolChain getToolChain() {
        return this.toolChain;
    }

    public JavaPlatform getTargetPlatform() {
        return this.platform;
    }

    public boolean isBuildable() {
        return true;
    }

    public boolean isLegacyBinary() {
        return true;
    }

    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    public String getName() {
        return this.name;
    }

    public File getClassesDir() {
        return this.classesDir;
    }

    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.source;
    }

    public void source(Object sources) {
        this.source.source(sources);
    }

    public String getDisplayName() {
        return this.namingScheme.getDescription();
    }

    public String toString() {
        return this.namingScheme.getDescription();
    }
}

