/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.plugins.AbstractRule;
import org.gradle.api.tasks.Upload;

public class UploadRule
extends AbstractRule {
    public static final String PREFIX = "upload";
    private final Project project;

    public UploadRule(Project project) {
        this.project = project;
    }

    public String getDescription() {
        return String.format("Pattern: %s<ConfigurationName>: Assembles and uploads the artifacts belonging to a configuration.", PREFIX);
    }

    public void apply(String taskName) {
        for (Configuration configuration : this.project.getConfigurations()) {
            if (!taskName.equals(configuration.getUploadTaskName())) continue;
            this.createUploadTask(configuration.getUploadTaskName(), configuration, this.project);
        }
    }

    private Upload createUploadTask(String name, Configuration configuration, final Project project) {
        Upload upload = (Upload)project.getTasks().create(name, Upload.class);
        upload.setDescription(String.format("Uploads all artifacts belonging to %s", configuration));
        upload.setGroup(PREFIX);
        upload.setConfiguration(configuration);
        upload.setUploadDescriptor(true);
        upload.getConventionMapping().map("descriptorDestination", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "ivy.xml");
            }
        });
        return upload;
    }
}

