/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.tasks.SourceSetOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSourceSetOutput
extends CompositeFileCollection
implements SourceSetOutput {
    private DefaultConfigurableFileCollection outputDirectories;
    private Object classesDir;
    private Object resourcesDir;
    private DefaultConfigurableFileCollection dirs;
    private FileResolver fileResolver;

    public DefaultSourceSetOutput(String sourceSetDisplayName, FileResolver fileResolver, TaskResolver taskResolver) {
        this.fileResolver = fileResolver;
        String displayName = String.format("%s output", sourceSetDisplayName);
        this.outputDirectories = new DefaultConfigurableFileCollection(displayName, fileResolver, taskResolver, new Object[]{new Callable(){

            public Object call() throws Exception {
                return DefaultSourceSetOutput.this.getClassesDir();
            }
        }, new Callable(){

            public Object call() throws Exception {
                return DefaultSourceSetOutput.this.getResourcesDir();
            }
        }});
        this.dirs = new DefaultConfigurableFileCollection("dirs", fileResolver, taskResolver, new Object[0]);
    }

    public void resolve(FileCollectionResolveContext context) {
        context.add((Object)this.outputDirectories);
    }

    public String getDisplayName() {
        return this.outputDirectories.getDisplayName();
    }

    @Override
    public File getClassesDir() {
        if (this.classesDir == null) {
            return null;
        }
        return this.fileResolver.resolve(this.classesDir);
    }

    @Override
    public void setClassesDir(Object classesDir) {
        this.classesDir = classesDir;
    }

    @Override
    public File getResourcesDir() {
        if (this.resourcesDir == null) {
            return null;
        }
        return this.fileResolver.resolve(this.resourcesDir);
    }

    @Override
    public void setResourcesDir(Object resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    public void builtBy(Object ... taskPaths) {
        this.outputDirectories.builtBy(taskPaths);
    }

    @Override
    public void dir(Object dir) {
        this.dir(new HashMap<String, Object>(), dir);
    }

    @Override
    public void dir(Map<String, Object> options, Object dir) {
        this.dirs.from(new Object[]{dir});
        this.outputDirectories.from(new Object[]{dir});
        Object builtBy = options.get("builtBy");
        if (builtBy != null) {
            this.builtBy(builtBy);
            this.dirs.builtBy(new Object[]{builtBy});
        }
    }

    @Override
    public FileCollection getDirs() {
        return this.dirs;
    }
}

