/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.io.IOException;
import java.io.Writer;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.PageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.TestResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.CodePanelRenderer;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassPageRenderer
extends PageRenderer<ClassTestResults> {
    private final CodePanelRenderer codePanelRenderer = new CodePanelRenderer();
    private final TestResultsProvider resultsProvider;

    public ClassPageRenderer(TestResultsProvider provider) {
        this.resultsProvider = provider;
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getParent().getParent())).characters((CharSequence)"all").endElement().characters((CharSequence)" > ").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getPackageResults())).characters((CharSequence)((ClassTestResults)this.getResults()).getPackageResults().getName()).endElement().characters((CharSequence)String.format(" > %s", ((ClassTestResults)this.getResults()).getSimpleName())).endElement();
    }

    private void renderTests(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table").startElement("thead").startElement("tr").startElement("th").characters((CharSequence)"Test").endElement().startElement("th").characters((CharSequence)"Duration").endElement().startElement("th").characters((CharSequence)"Result").endElement().endElement().endElement();
        for (TestResult test : ((ClassTestResults)this.getResults()).getTestResults()) {
            htmlWriter.startElement("tr").startElement("td").attribute("class", test.getStatusClass()).characters((CharSequence)test.getName()).endElement().startElement("td").characters((CharSequence)test.getFormattedDuration()).endElement().startElement("td").attribute("class", test.getStatusClass()).characters((CharSequence)test.getFormattedResultType()).endElement().endElement();
        }
        htmlWriter.endElement();
    }

    @Override
    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        for (TestResult test : ((ClassTestResults)this.getResults()).getFailures()) {
            htmlWriter.startElement("div").attribute("class", "test").startElement("a").attribute("name", test.getId().toString()).characters((CharSequence)"").endElement().startElement("h3").attribute("class", test.getStatusClass()).characters((CharSequence)test.getName()).endElement();
            for (TestFailure failure : test.getFailures()) {
                String message = GUtil.isTrue((Object)failure.getMessage()) && !failure.getStackTrace().contains(failure.getMessage()) ? failure.getMessage() + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator() + failure.getStackTrace() : failure.getStackTrace();
                this.codePanelRenderer.render(message, htmlWriter);
            }
            htmlWriter.endElement();
        }
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            public void doExecute(SimpleHtmlWriter writer) throws IOException {
                ClassPageRenderer.this.renderTests(writer);
            }
        });
        final long classId = ((ClassTestResults)this.getModel()).getId();
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdOut)) {
            this.addTab("Standard output", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                protected void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                    htmlWriter.startElement("span").attribute("class", "code").startElement("pre").characters((CharSequence)"");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdOut, (Writer)htmlWriter);
                    htmlWriter.endElement().endElement();
                }
            });
        }
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdErr)) {
            this.addTab("Standard error", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                protected void doExecute(SimpleHtmlWriter element) throws Exception {
                    element.startElement("span").attribute("class", "code").startElement("pre").characters((CharSequence)"");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdErr, (Writer)element);
                    element.endElement().endElement();
                }
            });
        }
    }
}

