/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.logging.StandardOutputRedirector;

public class CaptureTestOutputTestResultProcessor
implements TestResultProcessor {
    private final TestResultProcessor processor;
    private final StandardOutputRedirector outputRedirector;
    private Object suiteId;

    public CaptureTestOutputTestResultProcessor(TestResultProcessor processor, StandardOutputRedirector outputRedirector) {
        this.processor = processor;
        this.outputRedirector = outputRedirector;
    }

    public void started(TestDescriptorInternal test, TestStartEvent event) {
        this.processor.started(test, event);
        this.redirectOutputFor(test.getId());
        if (this.suiteId != null) {
            return;
        }
        this.suiteId = test.getId();
        this.outputRedirector.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(Object testId, TestCompleteEvent event) {
        if (testId.equals(this.suiteId)) {
            try {
                this.outputRedirector.stop();
            }
            finally {
                this.suiteId = null;
            }
        } else {
            this.redirectOutputFor(this.suiteId);
        }
        this.processor.completed(testId, event);
    }

    private void redirectOutputFor(Object testId) {
        this.outputRedirector.redirectStandardOutputTo((StandardOutputListener)new StdOutForwarder(testId));
        this.outputRedirector.redirectStandardErrorTo((StandardOutputListener)new StdErrForwarder(testId));
    }

    public void output(Object testId, TestOutputEvent event) {
        this.processor.output(testId, event);
    }

    public void failure(Object testId, Throwable result) {
        this.processor.failure(testId, result);
    }

    class StdErrForwarder
    implements StandardOutputListener {
        private final Object testId;

        public StdErrForwarder(Object testId) {
            this.testId = testId;
        }

        public void onOutput(CharSequence output) {
            CaptureTestOutputTestResultProcessor.this.processor.output(this.testId, new DefaultTestOutputEvent(TestOutputEvent.Destination.StdErr, output.toString()));
        }
    }

    class StdOutForwarder
    implements StandardOutputListener {
        private final Object testId;

        public StdOutForwarder(Object testId) {
            this.testId = testId;
        }

        public void onOutput(CharSequence output) {
            CaptureTestOutputTestResultProcessor.this.processor.output(this.testId, new DefaultTestOutputEvent(TestOutputEvent.Destination.StdOut, output.toString()));
        }
    }
}

