/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.TimeProvider;

public class TestMainAction
implements Runnable {
    private final TestClassProcessor processor;
    private final TestResultProcessor resultProcessor;
    private final TimeProvider timeProvider;
    private final Runnable detector;

    public TestMainAction(Runnable detector, TestClassProcessor processor, TestResultProcessor resultProcessor, TimeProvider timeProvider) {
        this.detector = detector;
        this.processor = processor;
        this.resultProcessor = new AttachParentTestResultProcessor(resultProcessor);
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RootTestSuiteDescriptor suite = new RootTestSuiteDescriptor();
        this.resultProcessor.started(suite, new TestStartEvent(this.timeProvider.getCurrentTime()));
        try {
            this.processor.startProcessing(this.resultProcessor);
            try {
                this.detector.run();
            }
            finally {
                this.processor.stop();
            }
        }
        finally {
            this.resultProcessor.completed(suite.getId(), new TestCompleteEvent(this.timeProvider.getCurrentTime()));
        }
    }

    private static class RootTestSuiteDescriptor
    extends DefaultTestSuiteDescriptor {
        public RootTestSuiteDescriptor() {
            super("root", "Test Run");
        }

        public String toString() {
            return "tests";
        }
    }
}

