/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.SourceSetCompileClasspath;
import org.gradle.api.internal.tasks.testing.NoMatchingTestsReporter;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.LegacyJavaComponentPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.ClassDirectoryBinarySpec;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.java.internal.DefaultJavaSourceSet;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.jvm.internal.DefaultJvmResourceSet;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CHECK_TASK_NAME = "check";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";
    public static final String BUILD_NEEDED_TASK_NAME = "buildNeeded";
    public static final String VERIFICATION_GROUP = "verification";
    public static final String DOCUMENTATION_GROUP = "documentation";
    private final Instantiator instantiator;

    @Inject
    public JavaBasePlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(ProjectInternal project) {
        project.getPlugins().apply(BasePlugin.class);
        project.getPlugins().apply(ReportingBasePlugin.class);
        project.getPlugins().apply(LegacyJavaComponentPlugin.class);
        JavaPluginConvention javaConvention = new JavaPluginConvention(project, this.instantiator);
        project.getConvention().getPlugins().put("java", javaConvention);
        this.configureCompileDefaults((Project)project, javaConvention);
        this.configureSourceSetDefaults(javaConvention);
        this.configureJavaDoc((Project)project, javaConvention);
        this.configureTest((Project)project, javaConvention);
        this.configureCheck((Project)project);
        this.configureBuild((Project)project);
        this.configureBuildNeeded((Project)project);
        this.configureBuildDependents((Project)project);
    }

    private void configureSourceSetDefaults(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        ProjectSourceSet projectSourceSet = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        pluginConvention.getSourceSets().all((Action)new Action<SourceSet>((Project)project, projectSourceSet){
            final /* synthetic */ Project val$project;
            final /* synthetic */ ProjectSourceSet val$projectSourceSet;
            {
                this.val$project = project;
                this.val$projectSourceSet = projectSourceSet;
            }

            public void execute(final SourceSet sourceSet) {
                ConventionMapping outputConventionMapping = ((IConventionAware)sourceSet.getOutput()).getConventionMapping();
                ConfigurationContainer configurations = this.val$project.getConfigurations();
                Configuration compileConfiguration = (Configuration)configurations.findByName(sourceSet.getCompileConfigurationName());
                if (compileConfiguration == null) {
                    compileConfiguration = (Configuration)configurations.create(sourceSet.getCompileConfigurationName());
                }
                compileConfiguration.setVisible(false);
                compileConfiguration.setDescription(String.format("Compile classpath for %s.", sourceSet));
                Configuration runtimeConfiguration = (Configuration)configurations.findByName(sourceSet.getRuntimeConfigurationName());
                if (runtimeConfiguration == null) {
                    runtimeConfiguration = (Configuration)configurations.create(sourceSet.getRuntimeConfigurationName());
                }
                runtimeConfiguration.setVisible(false);
                runtimeConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
                runtimeConfiguration.setDescription(String.format("Runtime classpath for %s.", sourceSet));
                sourceSet.setCompileClasspath((FileCollection)compileConfiguration);
                sourceSet.setRuntimeClasspath(sourceSet.getOutput().plus((FileCollection)runtimeConfiguration));
                outputConventionMapping.map("classesDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        String classesDirName = String.format("classes/%s", sourceSet.getName());
                        return new File(val$project.getBuildDir(), classesDirName);
                    }
                });
                outputConventionMapping.map("resourcesDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        String classesDirName = String.format("resources/%s", sourceSet.getName());
                        return new File(val$project.getBuildDir(), classesDirName);
                    }
                });
                sourceSet.getJava().srcDir((Object)String.format("src/%s/java", sourceSet.getName()));
                sourceSet.getResources().srcDir((Object)String.format("src/%s/resources", sourceSet.getName()));
                sourceSet.compiledBy(sourceSet.getClassesTaskName());
                FunctionalSourceSet functionalSourceSet = (FunctionalSourceSet)this.val$projectSourceSet.create(sourceSet.getName());
                SourceSetCompileClasspath compileClasspath = new SourceSetCompileClasspath(sourceSet);
                DefaultJavaSourceSet javaSourceSet = (DefaultJavaSourceSet)JavaBasePlugin.this.instantiator.newInstance(DefaultJavaSourceSet.class, new Object[]{"java", sourceSet.getJava(), compileClasspath, functionalSourceSet});
                functionalSourceSet.add((Object)javaSourceSet);
                JvmResourceSet resourceSet = (JvmResourceSet)JavaBasePlugin.this.instantiator.newInstance(DefaultJvmResourceSet.class, new Object[]{"resources", sourceSet.getResources(), functionalSourceSet});
                functionalSourceSet.add((Object)resourceSet);
                BinaryContainer binaryContainer = (BinaryContainer)this.val$project.getExtensions().getByType(BinaryContainer.class);
                ClassDirectoryBinarySpec binary = (ClassDirectoryBinarySpec)binaryContainer.create(String.format("%sClasses", sourceSet.getName()), ClassDirectoryBinarySpec.class);
                ConventionMapping conventionMapping = new DslObject((Object)binary).getConventionMapping();
                conventionMapping.map("classesDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return sourceSet.getOutput().getClassesDir();
                    }
                });
                conventionMapping.map("resourcesDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return sourceSet.getOutput().getResourcesDir();
                    }
                });
                binary.getSource().add((Object)javaSourceSet);
                binary.getSource().add((Object)resourceSet);
                binary.builtBy(new Object[]{sourceSet.getOutput().getDirs()});
            }
        });
    }

    public void configureForSourceSet(final SourceSet sourceSet, AbstractCompile compile) {
        compile.setDescription(String.format("Compiles the %s.", sourceSet.getJava()));
        ConventionMapping conventionMapping = compile.getConventionMapping();
        compile.setSource((Object)sourceSet.getJava());
        conventionMapping.map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath();
            }
        });
        conventionMapping.map("destinationDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getOutput().getClassesDir();
            }
        });
    }

    private void configureCompileDefaults(Project project, final JavaPluginConvention javaConvention) {
        project.getTasks().withType(AbstractCompile.class, (Action)new Action<AbstractCompile>(){

            public void execute(AbstractCompile compile) {
                ConventionMapping conventionMapping = compile.getConventionMapping();
                conventionMapping.map("sourceCompatibility", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getSourceCompatibility().toString();
                    }
                });
                conventionMapping.map("targetCompatibility", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getTargetCompatibility().toString();
                    }
                });
            }
        });
        project.getTasks().withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile compile) {
                ConventionMapping conventionMapping = compile.getConventionMapping();
                conventionMapping.map("dependencyCacheDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return javaConvention.getDependencyCacheDir();
                    }
                });
            }
        });
    }

    private void configureJavaDoc(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Javadoc.class, (Action)new Action<Javadoc>(){

            public void execute(Javadoc javadoc) {
                javadoc.getConventionMapping().map("destinationDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(convention.getDocsDir(), "javadoc");
                    }
                });
                javadoc.getConventionMapping().map("title", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getApiDocTitle();
                    }
                });
            }
        });
    }

    private void configureCheck(Project project) {
        Task checkTask = project.getTasks().create(CHECK_TASK_NAME);
        checkTask.setDescription("Runs all checks.");
        checkTask.setGroup(VERIFICATION_GROUP);
    }

    private void configureBuild(Project project) {
        DefaultTask buildTask = (DefaultTask)project.getTasks().create(BUILD_TASK_NAME, DefaultTask.class);
        buildTask.setDescription("Assembles and tests this project.");
        buildTask.setGroup(BUILD_TASK_NAME);
        buildTask.dependsOn(new Object[]{"assemble"});
        buildTask.dependsOn(new Object[]{CHECK_TASK_NAME});
    }

    private void configureBuildNeeded(Project project) {
        DefaultTask buildTask = (DefaultTask)project.getTasks().create(BUILD_NEEDED_TASK_NAME, DefaultTask.class);
        buildTask.setDescription("Assembles and tests this project and all projects it depends on.");
        buildTask.setGroup(BUILD_TASK_NAME);
        buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
    }

    private void configureBuildDependents(Project project) {
        DefaultTask buildTask = (DefaultTask)project.getTasks().create(BUILD_DEPENDENTS_TASK_NAME, DefaultTask.class);
        buildTask.setDescription("Assembles and tests this project and all projects that depend on it.");
        buildTask.setGroup(BUILD_TASK_NAME);
        buildTask.dependsOn(new Object[]{BUILD_TASK_NAME});
    }

    private void configureTest(final Project project, final JavaPluginConvention convention) {
        project.getTasks().withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                JavaBasePlugin.this.configureTestDefaults(test, project, convention);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                project.getTasks().withType(Test.class, (Action)new Action<Test>(){

                    public void execute(Test test) {
                        JavaBasePlugin.this.configureBasedOnSingleProperty(test);
                        JavaBasePlugin.this.overwriteDebugIfDebugPropertyIsSet(test);
                    }
                });
            }
        });
    }

    private void overwriteDebugIfDebugPropertyIsSet(Test test) {
        String debugProp = this.getTaskPrefixedProperty((Task)test, "debug");
        if (debugProp != null) {
            test.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    task.getLogger().info("Running tests for remote debugging.");
                }
            });
            test.setDebug(true);
        }
    }

    private void configureBasedOnSingleProperty(final Test test) {
        String singleTest = this.getTaskPrefixedProperty((Task)test, "single");
        if (singleTest == null) {
            test.getInputs().source((Object)test.getCandidateClassFiles());
            return;
        }
        test.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                test.getLogger().info("Running single tests with pattern: {}", test.getIncludes());
            }
        });
        test.setIncludes((Iterable)WrapUtil.toSet((Object[])new String[]{String.format("**/%s*.class", singleTest)}));
        test.addTestListener(new NoMatchingTestsReporter("Could not find matching test for pattern: " + singleTest));
    }

    private String getTaskPrefixedProperty(Task task, String propertyName) {
        String suffix = '.' + propertyName;
        String value = System.getProperty(task.getPath() + suffix);
        if (value == null) {
            return System.getProperty(task.getName() + suffix);
        }
        return value;
    }

    private void configureTestDefaults(final Test test, Project project, final JavaPluginConvention convention) {
        DslObject htmlReport = new DslObject((Object)test.getReports().getHtml());
        DslObject xmlReport = new DslObject((Object)test.getReports().getJunitXml());
        xmlReport.getConventionMapping().map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return convention.getTestResultsDir();
            }
        });
        htmlReport.getConventionMapping().map("destination", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return convention.getTestReportDir();
            }
        });
        test.getConventionMapping().map("binResultsDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(convention.getTestResultsDir(), String.format("binary/%s", test.getName()));
            }
        });
        test.workingDir(project.getProjectDir());
    }
}

