/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.assembler.tasks;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.assembler.internal.DefaultAssembleSpec;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class Assemble
extends DefaultTask {
    private FileCollection source = this.getProject().files(new Object[0]);
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private File objectFileDir;
    private List<String> assemblerArgs;

    @Inject
    public Assemble() {
    }

    @TaskAction
    public void assemble() {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getOutputs());
        cleaner.setDestinationDir(this.getObjectFileDir());
        cleaner.execute();
        DefaultAssembleSpec spec = new DefaultAssembleSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(this.getObjectFileDir());
        spec.source((Iterable<File>)this.getSource());
        spec.args(this.getAssemblerArgs());
        WorkResult result = this.toolChain.select(this.targetPlatform).newCompiler((CompileSpec)spec).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        DefaultGroovyMethods.invokeMethod((Object)this.source, (String)"from", (Object)new Object[]{sourceFiles});
    }

    @Input
    public List<String> getAssemblerArgs() {
        return this.assemblerArgs;
    }

    public void setAssemblerArgs(List<String> assemblerArgs) {
        this.assemblerArgs = assemblerArgs;
    }

    @Input
    public String getOutputType() {
        return this.toolChain.getOutputType() + ":" + this.targetPlatform.getCompatibilityString();
    }

    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @OutputDirectory
    public File getObjectFileDir() {
        return this.objectFileDir;
    }

    public void setObjectFileDir(File objectFileDir) {
        this.objectFileDir = objectFileDir;
    }
}

