/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.PreprocessingTool;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageRegistration;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.Tool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.platform.base.BinarySpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileTaskConfig
implements SourceTransformTaskConfig {
    private final LanguageRegistration<? extends LanguageSourceSet> language;
    private final Class<? extends DefaultTask> taskType;

    public CompileTaskConfig(LanguageRegistration<? extends LanguageSourceSet> languageRegistration, Class<? extends DefaultTask> taskType) {
        this.language = languageRegistration;
        this.taskType = taskType;
    }

    public String getTaskPrefix() {
        return "compile";
    }

    public Class<? extends DefaultTask> getTaskType() {
        return this.taskType;
    }

    public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet) {
        this.configureCompileTask((AbstractNativeCompileTask)task, (NativeBinarySpecInternal)binary, (LanguageSourceSetInternal)sourceSet);
    }

    private void configureCompileTask(AbstractNativeCompileTask task, final NativeBinarySpecInternal binary, final LanguageSourceSetInternal sourceSet) {
        task.setDescription(String.format("Compiles the %s of %s", sourceSet, binary));
        task.setToolChain(binary.getToolChain());
        task.setTargetPlatform(binary.getTargetPlatform());
        task.setPositionIndependentCode(binary instanceof SharedLibraryBinarySpec);
        task.includes(new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return ((HeaderExportingSourceSet)sourceSet).getExportedHeaders().getSrcDirs();
            }
        });
        task.includes(new Callable<List<FileCollection>>(){

            @Override
            public List<FileCollection> call() {
                Collection libs = binary.getLibs((DependentSourceSet)sourceSet);
                return CollectionUtils.collect((Iterable)libs, (Transformer)new Transformer<FileCollection, NativeDependencySet>(){

                    public FileCollection transform(NativeDependencySet original) {
                        return original.getIncludeRoots();
                    }
                });
            }
        });
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.setObjectFileDir(project.file((Object)(String.valueOf(project.getBuildDir()) + "/objs/" + binary.getNamingScheme().getOutputDirectoryBase() + "/" + sourceSet.getFullName())));
        for (String toolName : this.language.getBinaryTools().keySet()) {
            Tool tool = (Tool)((ExtensionAware)binary).getExtensions().getByName(toolName);
            if (tool instanceof PreprocessingTool) {
                task.setMacros(((PreprocessingTool)tool).getMacros());
            }
            task.setCompilerArgs(tool.getArgs());
        }
        binary.getTasks().getCreateOrLink().source((Object)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
    }
}

