/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.plugins.internal;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.PreprocessingTool;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.language.rc.tasks.WindowsResourceCompile;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.platform.base.BinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsResourcesCompileTaskConfig
implements SourceTransformTaskConfig {
    public String getTaskPrefix() {
        return "compile";
    }

    public Class<? extends DefaultTask> getTaskType() {
        return WindowsResourceCompile.class;
    }

    public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet) {
        this.configureResourceCompileTask((WindowsResourceCompile)task, (NativeBinarySpecInternal)binary, (WindowsResourceSet)sourceSet);
    }

    private void configureResourceCompileTask(WindowsResourceCompile task, NativeBinarySpecInternal binary, final WindowsResourceSet sourceSet) {
        task.setDescription(String.format("Compiles resources of the %s of %s", sourceSet, binary));
        task.setToolChain(binary.getToolChain());
        task.setTargetPlatform(binary.getTargetPlatform());
        task.includes(new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return sourceSet.getExportedHeaders().getSrcDirs();
            }
        });
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.setOutputDir(project.file((Object)(String.valueOf(project.getBuildDir()) + "/objs/" + binary.getNamingScheme().getOutputDirectoryBase() + "/" + ((LanguageSourceSetInternal)sourceSet).getFullName())));
        PreprocessingTool rcCompiler = (PreprocessingTool)((ExtensionAware)binary).getExtensions().getByName("rcCompiler");
        task.setMacros(rcCompiler.getMacros());
        task.setCompilerArgs(rcCompiler.getArgs());
        FileTree resourceOutputs = task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.res"}));
        binary.getTasks().getCreateOrLink().source((Object)resourceOutputs);
        if (binary instanceof StaticLibraryBinarySpecInternal) {
            ((StaticLibraryBinarySpecInternal)binary).additionalLinkFiles((FileCollection)resourceOutputs);
        }
    }
}

