/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.Plugin;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathPluginResolution
implements PluginResolution {
    private final PluginId pluginId;
    private final Instantiator instantiator;
    private final ClassLoaderScope parent;
    private final Factory<? extends ClassPath> classPathFactory;

    public ClassPathPluginResolution(Instantiator instantiator, PluginId pluginId, ClassLoaderScope parent, Factory<? extends ClassPath> classPathFactory) {
        this.pluginId = pluginId;
        this.instantiator = instantiator;
        this.parent = parent;
        this.classPathFactory = classPathFactory;
    }

    @Override
    public PluginId getPluginId() {
        return this.pluginId;
    }

    @Override
    public Class<? extends Plugin> resolve() {
        ClassPath classPath = (ClassPath)this.classPathFactory.create();
        ClassLoaderScope loaderScope = this.parent.createChild();
        loaderScope.local(classPath);
        loaderScope.lock();
        DefaultPluginRegistry pluginRegistry = new DefaultPluginRegistry(loaderScope.getLocalClassLoader(), this.instantiator);
        return pluginRegistry.getTypeForId(this.pluginId.toString());
    }
}

