/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.Actions;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResponseResource;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.service.internal.ClientStatus;
import org.gradle.plugin.use.resolve.service.internal.ErrorResponse;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceClient;
import org.gradle.plugin.use.resolve.service.internal.PluginUseMetaData;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPluginResolutionServiceClient
implements PluginResolutionServiceClient {
    private static final Escaper PATH_SEGMENT_ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpPluginResolutionServiceClient.class);
    private static final String CLIENT_REQUEST_BASE = String.format("%s", PATH_SEGMENT_ESCAPER.escape(GradleVersion.current().getVersion()));
    private static final String PLUGIN_USE_REQUEST_URL = "/plugin/use/%s/%s";
    private static final String JSON = "application/json";
    public static final String CLIENT_STATUS_CHECKSUM_HEADER = "X-Gradle-Client-Status-Checksum";
    private final HttpResourceAccessor resourceAccessor;

    public HttpPluginResolutionServiceClient(HttpResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    @Override
    @Nullable
    public PluginResolutionServiceClient.Response<PluginUseMetaData> queryPluginMetadata(String portalUrl, boolean shouldValidate, PluginRequest pluginRequest) {
        String escapedId = PATH_SEGMENT_ESCAPER.escape(pluginRequest.getId().toString());
        String escapedPluginVersion = PATH_SEGMENT_ESCAPER.escape(pluginRequest.getVersion());
        final String requestUrl = this.toRequestUrl(portalUrl, String.format(PLUGIN_USE_REQUEST_URL, escapedId, escapedPluginVersion));
        return this.request(requestUrl, PluginUseMetaData.class, new Action<PluginUseMetaData>(){

            public void execute(PluginUseMetaData pluginUseMetaData) {
                HttpPluginResolutionServiceClient.this.validate(requestUrl, pluginUseMetaData);
            }
        });
    }

    @Override
    public PluginResolutionServiceClient.Response<ClientStatus> queryClientStatus(String portalUrl, boolean shouldValidate, String checksum) {
        String requestUrl = this.toRequestUrl(portalUrl, "");
        return this.request(requestUrl, ClientStatus.class, Actions.doNothing());
    }

    private String toRequestUrl(String portalUrl, String path) {
        return String.format("%s/%s%s", portalUrl, CLIENT_REQUEST_BASE, path);
    }

    private <T> PluginResolutionServiceClient.Response<T> request(final String requestUrl, final Class<T> type, final Action<? super T> validator) {
        URI requestUri = this.toUri(requestUrl, "plugin request");
        HttpResponseResource response = null;
        try {
            response = this.resourceAccessor.getRawResource(requestUri);
            final int statusCode = response.getStatusCode();
            String contentType = response.getContentType();
            if (contentType == null || !contentType.equalsIgnoreCase(JSON)) {
                String message = String.format("content type is '%s', expected '%s'", contentType == null ? "" : contentType, JSON);
                throw new OutOfProtocolException(requestUrl, message);
            }
            final String clientStatusChecksum = response.getHeaderValue(CLIENT_STATUS_CHECKSUM_HEADER);
            PluginResolutionServiceClient.Response response2 = (PluginResolutionServiceClient.Response)response.withContent(new Transformer<PluginResolutionServiceClient.Response<T>, InputStream>(){

                public PluginResolutionServiceClient.Response<T> transform(InputStream inputStream) {
                    InputStreamReader reader;
                    try {
                        reader = new InputStreamReader(inputStream, "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AssertionError((Object)e);
                    }
                    try {
                        if (statusCode == 200) {
                            Object payload = new Gson().fromJson((Reader)reader, type);
                            validator.execute(payload);
                            return new PluginResolutionServiceClient.SuccessResponse<Object>(payload, statusCode, requestUrl, clientStatusChecksum);
                        }
                        if (statusCode >= 400 && statusCode < 600) {
                            ErrorResponse errorResponse = HttpPluginResolutionServiceClient.this.validate(requestUrl, (ErrorResponse)new Gson().fromJson((Reader)reader, ErrorResponse.class));
                            return new PluginResolutionServiceClient.ErrorResponseResponse(errorResponse, statusCode, requestUrl, clientStatusChecksum);
                        }
                        throw new OutOfProtocolException(requestUrl, "unexpected HTTP response status " + statusCode);
                    }
                    catch (JsonSyntaxException e) {
                        throw new OutOfProtocolException(requestUrl, "could not parse response JSON", e);
                    }
                    catch (JsonIOException e) {
                        throw new OutOfProtocolException(requestUrl, "could not parse response JSON", e);
                    }
                }
            });
            return response2;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error closing HTTP resource", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    private PluginUseMetaData validate(String url, PluginUseMetaData pluginUseMetaData) {
        if (pluginUseMetaData.implementationType == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no implementation type specified");
        }
        if (!pluginUseMetaData.implementationType.equals("M2_JAR")) {
            throw new OutOfProtocolException(url, String.format("invalid plugin metadata - unsupported implementation type '%s'", pluginUseMetaData.implementationType));
        }
        if (pluginUseMetaData.implementation == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no implementation specified");
        }
        if (pluginUseMetaData.implementation.get("gav") == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no module coordinates specified");
        }
        if (pluginUseMetaData.implementation.get("repo") == null) {
            throw new OutOfProtocolException(url, "invalid plugin metadata - no module repository specified");
        }
        return pluginUseMetaData;
    }

    private ErrorResponse validate(String url, ErrorResponse errorResponse) {
        if (errorResponse.errorCode == null) {
            throw new OutOfProtocolException(url, "invalid error response - no error code specified");
        }
        if (errorResponse.message == null) {
            throw new OutOfProtocolException(url, "invalid error response - no message specified");
        }
        return errorResponse;
    }

    private URI toUri(String url, String kind) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new GradleException(String.format("Invalid %s URL: %s", kind, url), (Throwable)e);
        }
    }

    private static class OutOfProtocolException
    extends GradleException {
        private OutOfProtocolException(String requestUrl, String message) {
            super(OutOfProtocolException.toMessage(requestUrl, message));
        }

        private OutOfProtocolException(String requestUrl, String message, Throwable cause) {
            super(OutOfProtocolException.toMessage(requestUrl, message), cause);
        }

        private static String toMessage(String requestUrl, String message) {
            return String.format("The response from %s was not a valid response from a Gradle Plugin Resolution Service: %s", requestUrl, message);
        }
    }
}

