/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import java.io.IOException;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.service.internal.ClientStatus;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceClient;
import org.gradle.plugin.use.resolve.service.internal.PluginUseMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentCachingPluginResolutionServiceClient
implements PluginResolutionServiceClient {
    public static final String PLUGIN_USE_METADATA_CACHE_NAME = "plugin-use-metadata";
    public static final String PLUGIN_USE_METADATA_OP_NAME = "queryPluginMetadata";
    public static final String CLIENT_STATUS_CACHE_NAME = "client-status";
    public static final String CLIENT_STATUS_OP_NAME = "queryClientStatus";
    private final PluginResolutionServiceClient delegate;
    private final PersistentCache cacheAccess;
    private final PersistentIndexedCache<PluginRequestKey, PluginResolutionServiceClient.Response<PluginUseMetaData>> pluginUseMetadataCache;
    private final PersistentIndexedCache<ClientStatusKey, PluginResolutionServiceClient.Response<ClientStatus>> clientStatusCache;

    public PersistentCachingPluginResolutionServiceClient(PluginResolutionServiceClient delegate, PersistentCache persistentCache) {
        this.delegate = delegate;
        this.cacheAccess = persistentCache;
        this.pluginUseMetadataCache = persistentCache.createCache(PersistentIndexedCacheParameters.of((String)PLUGIN_USE_METADATA_CACHE_NAME, (Serializer)new PluginRequestKey.Serializer(), (Serializer)ResponseSerializer.of(new PluginUseMetaData.Serializer())));
        this.clientStatusCache = persistentCache.createCache(PersistentIndexedCacheParameters.of((String)CLIENT_STATUS_CACHE_NAME, (Serializer)new ClientStatusKey.Serializer(), (Serializer)ResponseSerializer.of(new ClientStatus.Serializer())));
    }

    @Override
    public PluginResolutionServiceClient.Response<PluginUseMetaData> queryPluginMetadata(final String portalUrl, final boolean shouldValidate, final PluginRequest pluginRequest) {
        PluginRequestKey key = PluginRequestKey.of(portalUrl, pluginRequest);
        Factory<PluginResolutionServiceClient.Response<PluginUseMetaData>> factory = new Factory<PluginResolutionServiceClient.Response<PluginUseMetaData>>(){

            public PluginResolutionServiceClient.Response<PluginUseMetaData> create() {
                return PersistentCachingPluginResolutionServiceClient.this.delegate.queryPluginMetadata(portalUrl, shouldValidate, pluginRequest);
            }
        };
        if (shouldValidate) {
            return this.fetch(PLUGIN_USE_METADATA_OP_NAME, this.pluginUseMetadataCache, key, factory);
        }
        return this.maybeFetch(PLUGIN_USE_METADATA_OP_NAME, this.pluginUseMetadataCache, key, factory);
    }

    @Override
    public PluginResolutionServiceClient.Response<ClientStatus> queryClientStatus(final String portalUrl, final boolean shouldValidate, final String checksum) {
        ClientStatusKey key = new ClientStatusKey(portalUrl);
        Factory<PluginResolutionServiceClient.Response<ClientStatus>> factory = new Factory<PluginResolutionServiceClient.Response<ClientStatus>>(){

            public PluginResolutionServiceClient.Response<ClientStatus> create() {
                return PersistentCachingPluginResolutionServiceClient.this.delegate.queryClientStatus(portalUrl, shouldValidate, checksum);
            }
        };
        if (shouldValidate) {
            return this.fetch(CLIENT_STATUS_OP_NAME, this.clientStatusCache, key, factory);
        }
        return this.maybeFetch(CLIENT_STATUS_OP_NAME, this.clientStatusCache, key, factory, new Spec<PluginResolutionServiceClient.Response<ClientStatus>>(){

            public boolean isSatisfiedBy(PluginResolutionServiceClient.Response<ClientStatus> element) {
                return !element.getClientStatusChecksum().equals(checksum);
            }
        });
    }

    private <K, V extends PluginResolutionServiceClient.Response<?>> V maybeFetch(String operationName, PersistentIndexedCache<K, V> cache, K key, Factory<V> factory) {
        return this.maybeFetch(operationName, cache, key, factory, Specs.SATISFIES_NONE);
    }

    private <K, V extends PluginResolutionServiceClient.Response<?>> V maybeFetch(String operationName, final PersistentIndexedCache<K, V> cache, final K key, Factory<V> factory, Spec<? super V> shouldFetch) {
        boolean fetch;
        PluginResolutionServiceClient.Response cachedValue = (PluginResolutionServiceClient.Response)this.cacheAccess.useCache(operationName + " - read", new Factory<V>(){

            public V create() {
                return (PluginResolutionServiceClient.Response)cache.get(key);
            }
        });
        boolean bl = fetch = cachedValue == null || shouldFetch.isSatisfiedBy((Object)cachedValue);
        if (fetch) {
            return this.fetch(operationName, cache, key, factory);
        }
        return (V)cachedValue;
    }

    private <K, V extends PluginResolutionServiceClient.Response<?>> V fetch(String operationName, final PersistentIndexedCache<K, V> cache, final K key, Factory<V> factory) {
        final PluginResolutionServiceClient.Response value = (PluginResolutionServiceClient.Response)factory.create();
        if (value.isError()) {
            return (V)value;
        }
        this.cacheAccess.useCache(operationName + " - write", new Runnable(){

            public void run() {
                cache.put(key, (Object)value);
            }
        });
        return (V)value;
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.delegate, this.cacheAccess}).stop();
    }

    public static class ClientStatusKey {
        private final String portalUrl;

        public ClientStatusKey(String portalUrl) {
            this.portalUrl = portalUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientStatusKey that = (ClientStatusKey)o;
            return this.portalUrl.equals(that.portalUrl);
        }

        public int hashCode() {
            return this.portalUrl.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Serializer
        implements org.gradle.messaging.serialize.Serializer<ClientStatusKey> {
            public ClientStatusKey read(Decoder decoder) throws Exception {
                return new ClientStatusKey(decoder.readString());
            }

            public void write(Encoder encoder, ClientStatusKey value) throws Exception {
                encoder.writeString((CharSequence)value.portalUrl);
            }
        }
    }

    static class PluginRequestKey {
        private final String id;
        private final String version;
        private final String url;

        private static PluginRequestKey of(String url, PluginRequest pluginRequest) {
            return new PluginRequestKey(pluginRequest.getId().toString(), pluginRequest.getVersion(), url);
        }

        private PluginRequestKey(String id, String version, String url) {
            this.id = id;
            this.version = version;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginRequestKey key = (PluginRequestKey)o;
            return this.id.equals(key.id) && this.url.equals(key.url) && this.version.equals(key.version);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.version.hashCode();
            result = 31 * result + this.url.hashCode();
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Serializer
        implements org.gradle.messaging.serialize.Serializer<PluginRequestKey> {
            private Serializer() {
            }

            public PluginRequestKey read(Decoder decoder) throws Exception {
                return new PluginRequestKey(decoder.readString(), decoder.readString(), decoder.readString());
            }

            public void write(Encoder encoder, PluginRequestKey value) throws Exception {
                encoder.writeString((CharSequence)value.id);
                encoder.writeString((CharSequence)value.version);
                encoder.writeString((CharSequence)value.url);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResponseSerializer<T>
    implements Serializer<PluginResolutionServiceClient.Response<T>> {
        private final Serializer<T> payloadSerializer;

        private static <T> ResponseSerializer<T> of(Serializer<T> payloadSerializer) {
            return new ResponseSerializer<T>(payloadSerializer);
        }

        private ResponseSerializer(Serializer<T> payloadSerializer) {
            this.payloadSerializer = payloadSerializer;
        }

        public PluginResolutionServiceClient.Response<T> read(Decoder decoder) throws Exception {
            return new PluginResolutionServiceClient.SuccessResponse<Object>(this.payloadSerializer.read(decoder), decoder.readSmallInt(), decoder.readString(), decoder.readNullableString());
        }

        public void write(Encoder encoder, PluginResolutionServiceClient.Response<T> value) throws Exception {
            T response = value.getResponse();
            this.payloadSerializer.write(encoder, response);
            encoder.writeSmallInt(value.getStatusCode());
            encoder.writeString((CharSequence)value.getUrl());
            encoder.writeNullableString((CharSequence)value.getClientStatusChecksum());
        }
    }
}

