/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.codehaus.plexus.interpolation.os;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import org.gradle.mvn3.org.codehaus.plexus.interpolation.os.Os;

public final class OperatingSystemUtils {
    private OperatingSystemUtils() {
    }

    public static Properties getSystemEnvVars() throws IOException {
        return OperatingSystemUtils.getSystemEnvVars(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSystemEnvVars(boolean caseSensitive) throws IOException {
        Process p = null;
        try {
            String line;
            Properties envVars = new Properties();
            Runtime r = Runtime.getRuntime();
            p = Os.isFamily("windows") ? (Os.isFamily("win9x") ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec("env");
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String lastKey = null;
            String lastVal = null;
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                if (idx > 0) {
                    lastKey = line.substring(0, idx);
                    if (!caseSensitive) {
                        lastKey = lastKey.toUpperCase(Locale.ENGLISH);
                    }
                    lastVal = line.substring(idx + 1);
                    envVars.setProperty(lastKey, lastVal);
                    continue;
                }
                if (lastKey == null) continue;
                lastVal = lastVal + "\n" + line;
                envVars.setProperty(lastKey, lastVal);
            }
            Properties properties = envVars;
            return properties;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }
}

