/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.repository.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.Metadata;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.gradle.mvn3.org.codehaus.plexus.util.IOUtil;
import org.gradle.mvn3.org.codehaus.plexus.util.ReaderFactory;
import org.gradle.mvn3.org.codehaus.plexus.util.WriterFactory;
import org.gradle.mvn3.org.codehaus.plexus.util.xml.XmlStreamReader;
import org.gradle.mvn3.org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.gradle.mvn3.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.gradle.mvn3.org.sonatype.aether.RepositoryException;
import org.gradle.mvn3.org.sonatype.aether.metadata.MergeableMetadata;

abstract class MavenMetadata
implements MergeableMetadata {
    private final File file;
    protected Metadata metadata;
    private boolean merged;

    protected MavenMetadata(Metadata metadata, File file) {
        this.metadata = metadata;
        this.file = file;
    }

    public String getType() {
        return "maven-metadata.xml";
    }

    public File getFile() {
        return this.file;
    }

    public void merge(File existing, File result) throws RepositoryException {
        Metadata recessive = this.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(Metadata var1);

    private Metadata read(File metadataFile) throws RepositoryException {
        if (metadataFile.length() <= 0L) {
            return new Metadata();
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)metadataFile);
            Metadata metadata = new MetadataXpp3Reader().read((Reader)reader, false);
            return metadata;
        }
        catch (IOException e) {
            throw new RepositoryException("Could not read metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryException("Could not parse metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private void write(File metadataFile, Metadata metadata) throws RepositoryException {
        XmlStreamWriter writer = null;
        try {
            metadataFile.getParentFile().mkdirs();
            writer = WriterFactory.newXmlWriter((File)metadataFile);
            new MetadataXpp3Writer().write((Writer)writer, metadata);
        }
        catch (IOException e) {
            try {
                throw new RepositoryException("Could not write metadata " + metadataFile + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.getGroupId().length() > 0) {
            buffer.append(this.getGroupId());
        }
        if (this.getArtifactId().length() > 0) {
            buffer.append(':').append(this.getArtifactId());
        }
        if (this.getVersion().length() > 0) {
            buffer.append(':').append(this.getVersion());
        }
        buffer.append('/').append(this.getType());
        return buffer.toString();
    }
}

