/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.logging.internal.ColorMap;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.ConsoleBackedProgressRenderer;
import org.gradle.logging.internal.DefaultColorMap;
import org.gradle.logging.internal.DefaultStatusBarFormatter;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressLogEventGenerator;
import org.gradle.logging.internal.StreamBackedStandardOutputListener;
import org.gradle.logging.internal.StreamingStyledTextOutput;
import org.gradle.logging.internal.StyledTextOutputBackedRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class OutputEventRenderer
implements OutputEventListener,
LoggingConfigurer,
LoggingOutputInternal {
    private final ListenerBroadcast<OutputEventListener> formatters = new ListenerBroadcast<OutputEventListener>(OutputEventListener.class);
    private final ListenerBroadcast<StandardOutputListener> stdoutListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private final ListenerBroadcast<StandardOutputListener> stderrListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
    private final Object lock = new Object();
    private final DefaultColorMap colourMap = new DefaultColorMap();
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private final Action<? super OutputEventRenderer> consoleConfigureAction;
    private OutputStream originalStdOut;
    private OutputStream originalStdErr;
    private StreamBackedStandardOutputListener stdOutListener;
    private StreamBackedStandardOutputListener stdErrListener;

    public OutputEventRenderer(Action<? super OutputEventRenderer> consoleConfigureAction) {
        OutputEventListener stdOutChain = this.onNonError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.stdoutListeners.getSource())), false));
        this.formatters.add(stdOutChain);
        OutputEventListener stdErrChain = this.onError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.stderrListeners.getSource())), false));
        this.formatters.add(stdErrChain);
        this.consoleConfigureAction = consoleConfigureAction;
    }

    public ColorMap getColourMap() {
        return this.colourMap;
    }

    public OutputStream getOriginalStdOut() {
        return this.originalStdOut;
    }

    public OutputStream getOriginalStdErr() {
        return this.originalStdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachConsole(boolean colorOutput) {
        Object object = this.lock;
        synchronized (object) {
            this.colourMap.setUseColor(colorOutput);
            this.consoleConfigureAction.execute((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStandardOutputAndError() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdOut = System.out;
            this.originalStdErr = System.err;
            this.stdOutListener = new StreamBackedStandardOutputListener(System.out);
            this.stdErrListener = new StreamBackedStandardOutputListener(System.err);
            this.addStandardOutputListener(this.stdOutListener);
            this.addStandardErrorListener(this.stdErrListener);
        }
    }

    @Override
    public void addOutputEventListener(OutputEventListener listener) {
        this.formatters.add(listener);
    }

    @Override
    public void removeOutputEventListener(OutputEventListener listener) {
        this.formatters.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputEventRenderer addConsole(Console console, boolean stdout, boolean stderr, ConsoleMetaData consoleMetaData) {
        ConsoleBackedProgressRenderer consoleChain = new ConsoleBackedProgressRenderer(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(console.getMainArea()), true), console, new DefaultStatusBarFormatter(consoleMetaData));
        Object object = this.lock;
        synchronized (object) {
            if (stdout && stderr) {
                this.formatters.add(consoleChain);
                this.stdoutListeners.remove(this.stdOutListener);
                this.stderrListeners.remove(this.stdErrListener);
            } else if (stdout) {
                this.formatters.add(this.onNonError(consoleChain));
                this.stdoutListeners.remove(this.stdOutListener);
            } else {
                this.formatters.add(this.onError(consoleChain));
                this.stderrListeners.remove(this.stdErrListener);
            }
            consoleChain.onOutput(new LogLevelChangeEvent(this.logLevel));
        }
        return this;
    }

    private OutputEventListener onError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() == LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    private OutputEventListener onNonError(final OutputEventListener listener) {
        return new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() != LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.remove(listener);
        }
    }

    @Override
    public void configure(LogLevel logLevel) {
        this.onOutput(new LogLevelChangeEvent(logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOutput(OutputEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getLogLevel() != null && event.getLogLevel().compareTo(this.logLevel) < 0) {
                return;
            }
            if (event instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
                LogLevel newLogLevel = changeEvent.getNewLogLevel();
                if (newLogLevel == this.logLevel) {
                    return;
                }
                this.logLevel = newLogLevel;
            }
            this.formatters.getSource().onOutput(event);
        }
    }
}

