/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.internal.resource.ResourceException;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transport.http.ApacheDirectoryListingParser;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResponseResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResourceLister
implements ExternalResourceLister {
    private HttpResourceAccessor accessor;

    public HttpResourceLister(HttpResourceAccessor accessor) {
        this.accessor = accessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> list(final URI parent) throws IOException {
        final HttpResponseResource resource = this.accessor.getResource(parent);
        if (resource == null) {
            return null;
        }
        try {
            List list = (List)resource.withContent((Transformer)new Transformer<List<String>, InputStream>(){

                public List<String> transform(InputStream inputStream) {
                    String contentType = resource.getContentType();
                    ApacheDirectoryListingParser directoryListingParser = new ApacheDirectoryListingParser();
                    try {
                        return directoryListingParser.parse(parent, inputStream, contentType);
                    }
                    catch (Exception e) {
                        throw new ResourceException("Unable to parse HTTP directory listing.", (Throwable)e);
                    }
                }
            });
            return list;
        }
        finally {
            resource.close();
        }
    }
}

