/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.jvm.Jvm;
import org.gradle.language.base.internal.compile.Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkJavaCompiler
implements Compiler<JavaCompileSpec>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkJavaCompiler.class);

    public WorkResult execute(JavaCompileSpec spec) {
        LOGGER.info("Compiling with JDK Java compiler API.");
        JavaCompiler.CompilationTask task = this.createCompileTask(spec);
        boolean success = task.call();
        if (!success) {
            throw new CompilationFailedException();
        }
        return new SimpleWorkResult(true);
    }

    private JavaCompiler.CompilationTask createCompileTask(JavaCompileSpec spec) {
        List<String> options = new JavaCompilerArgumentsBuilder(spec).build();
        JavaCompiler compiler = JdkJavaCompiler.findCompiler();
        if (compiler == null) {
            throw new RuntimeException("Cannot find System Java Compiler. Ensure that you have installed a JDK (not just a JRE) and configured your JAVA_HOME system variable to point to the according directory.");
        }
        CompileOptions compileOptions = spec.getCompileOptions();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, compileOptions.getEncoding() != null ? Charset.forName(compileOptions.getEncoding()) : null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles((Iterable<? extends File>)spec.getSource());
        return compiler.getTask(null, null, null, options, null, compilationUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaCompiler findCompiler() {
        File javaHomeFromToolProvidersPointOfView;
        File realJavaHome = Jvm.current().getJavaHome();
        if (realJavaHome.equals(javaHomeFromToolProvidersPointOfView = new File(System.getProperty("java.home")))) {
            return ToolProvider.getSystemJavaCompiler();
        }
        System.setProperty("java.home", realJavaHome.getAbsolutePath());
        try {
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            return javaCompiler;
        }
        finally {
            System.setProperty("java.home", javaHomeFromToolProvidersPointOfView.getAbsolutePath());
        }
    }
}

