/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.messaging.serialize.BaseSerializerFactory;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.MapSerializer;
import org.gradle.messaging.serialize.SetSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSetAnalysisData {
    final Map<String, DependentsSet> dependents;

    public ClassSetAnalysisData(Map<String, DependentsSet> dependents) {
        this.dependents = dependents;
    }

    public DependentsSet getDependents(String className) {
        return this.dependents.get(className);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Serializer
    implements org.gradle.messaging.serialize.Serializer<ClassSetAnalysisData> {
        private final MapSerializer<String, DependentsSet> serializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, (org.gradle.messaging.serialize.Serializer)new DependentsSetSerializer());

        public ClassSetAnalysisData read(Decoder decoder) throws Exception {
            return new ClassSetAnalysisData(this.serializer.read(decoder));
        }

        public void write(Encoder encoder, ClassSetAnalysisData value) throws Exception {
            this.serializer.write(encoder, value.dependents);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DependentsSetSerializer
        implements org.gradle.messaging.serialize.Serializer<DependentsSet> {
            private SetSerializer<String> setSerializer = new SetSerializer(BaseSerializerFactory.STRING_SERIALIZER, false);

            private DependentsSetSerializer() {
            }

            public DependentsSet read(Decoder decoder) throws Exception {
                int control = decoder.readSmallInt();
                if (control == 0) {
                    return new DependencyToAll();
                }
                if (control != 1 && control != 2) {
                    throw new IllegalArgumentException("Unable to read the data. Unexpected control value: " + control);
                }
                Set classes = this.setSerializer.read(decoder);
                return new DefaultDependentsSet(control == 1, classes);
            }

            public void write(Encoder encoder, DependentsSet value) throws Exception {
                if (value instanceof DependencyToAll) {
                    encoder.writeSmallInt(0);
                } else if (value instanceof DefaultDependentsSet) {
                    encoder.writeSmallInt(value.isDependencyToAll() ? 1 : 2);
                    this.setSerializer.write(encoder, value.getDependentClasses());
                } else {
                    throw new IllegalArgumentException("Don't know how to serialize value of type: " + value.getClass() + ", value: " + value);
                }
            }
        }
    }
}

