/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.bootstrap.EntryPoint;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.launcher.daemon.configuration.DefaultDaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonServices;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.messaging.remote.Address;

public class DaemonMain
extends EntryPoint {
    private static final Logger LOGGER = Logging.getLogger(DaemonMain.class);
    private PrintStream originalOut;
    private PrintStream originalErr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction(String[] args, ExecutionListener listener) {
        if (args.length < 4) {
            DaemonMain.invalidArgs("Following arguments are required: <gradle-version> <daemon-dir> <timeout-millis> <daemonUid> <optional startup jvm opts>");
        }
        File daemonBaseDir = new File(args[1]);
        int idleTimeoutMs = 0;
        try {
            idleTimeoutMs = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            DaemonMain.invalidArgs("Second argument must be a whole number (i.e. daemon idle timeout in ms)");
        }
        String daemonUid = args[3];
        LinkedList<String> startupOpts = new LinkedList<String>();
        for (int i = 4; i < args.length; ++i) {
            startupOpts.add(args[i]);
        }
        LOGGER.debug("Assuming the daemon was started with following jvm opts: {}", startupOpts);
        DefaultDaemonServerConfiguration parameters = new DefaultDaemonServerConfiguration(daemonUid, daemonBaseDir, idleTimeoutMs, startupOpts);
        LoggingServiceRegistry loggingRegistry = LoggingServiceRegistry.newProcessLogging();
        LoggingManagerInternal loggingManager = loggingRegistry.newInstance(LoggingManagerInternal.class);
        DaemonServices daemonServices = new DaemonServices(parameters, (ServiceRegistry)loggingRegistry, loggingManager);
        File daemonLog = daemonServices.getDaemonLogFile();
        this.initialiseLogging(loggingManager, daemonLog);
        Daemon daemon = daemonServices.get(Daemon.class);
        daemon.start();
        try {
            DaemonContext daemonContext = daemonServices.get(DaemonContext.class);
            Long pid = daemonContext.getPid();
            this.daemonStarted(pid, daemon.getUid(), daemon.getAddress(), daemonLog);
            daemon.requestStopOnIdleTimeout(parameters.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        finally {
            daemon.stop();
        }
    }

    private static void invalidArgs(String message) {
        System.out.println("USAGE: <gradle version> <path to registry base dir> <idle timeout in milliseconds>");
        System.out.println(message);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void daemonStarted(Long pid, String uid, Address address, File daemonLog) {
        new DaemonStartupCommunication().printDaemonStarted(this.originalOut, pid, uid, address, daemonLog);
        try {
            this.originalOut.close();
            this.originalErr.close();
        }
        finally {
            this.originalOut = null;
            this.originalErr = null;
        }
    }

    protected void initialiseLogging(LoggingManagerInternal loggingManager, File daemonLog) {
        PrintStream result;
        try {
            Files.createParentDirs((File)daemonLog);
            result = new PrintStream(new FileOutputStream(daemonLog), true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create daemon log file", e);
        }
        final PrintStream log = result;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                log.println("Daemon vm is shutting down... The daemon has exited normally or was terminated in response to a user interrupt.");
            }
        });
        this.redirectOutputsAndInput(log);
        loggingManager.addStandardOutputAndError();
        loggingManager.setLevel(LogLevel.DEBUG);
        loggingManager.start();
    }

    private void redirectOutputsAndInput(PrintStream printStream) {
        this.originalOut = System.out;
        this.originalErr = System.err;
        System.setOut(printStream);
        System.setErr(printStream);
        System.setIn(new ByteArrayInputStream(new byte[0]));
    }
}

