/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Scanner;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.process.internal.streams.StreamsHandler;

public class DaemonOutputConsumer
implements StreamsHandler {
    private static final Logger LOGGER = Logging.getLogger(DaemonOutputConsumer.class);
    private StringWriter output;
    private StoppableExecutor executor;
    private Runnable streamConsumer;
    DaemonStartupCommunication startupCommunication = new DaemonStartupCommunication();
    private String processOutput;

    public void connectStreams(Process process, String processName) {
        if (process == null || processName == null) {
            throw new IllegalArgumentException("Cannot connect streams because provided process or its name is null");
        }
        InputStream inputStream = process.getInputStream();
        this.connectStreams(inputStream, processName);
    }

    public void start() {
        if (this.executor == null || this.streamConsumer == null) {
            throw new IllegalStateException("Cannot start consuming daemon output because streams have not been connected first.");
        }
        LOGGER.debug("Starting consuming the daemon process output.");
        this.output = new StringWriter();
        this.executor.execute(this.streamConsumer);
    }

    void connectStreams(final InputStream inputStream, String processName) {
        this.executor = new DefaultExecutorFactory().create("Read output from: " + processName);
        this.streamConsumer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Scanner scanner = new Scanner(inputStream);
                PrintWriter printer = new PrintWriter(DaemonOutputConsumer.this.output);
                try {
                    while (scanner.hasNext()) {
                        String line = scanner.nextLine();
                        LOGGER.debug("daemon out: {}", line);
                        printer.println(line);
                        if (!DaemonOutputConsumer.this.startupCommunication.containsGreeting(line)) continue;
                        break;
                    }
                }
                finally {
                    scanner.close();
                }
            }
        };
    }

    public String getProcessOutput() {
        if (this.processOutput == null) {
            throw new IllegalStateException("Unable to get process output as consuming has not finished yet.");
        }
        return this.processOutput;
    }

    public void stop() {
        if (this.executor == null || this.output == null) {
            throw new IllegalStateException("Unable to stop output consumer. Was it started?.");
        }
        this.executor.stop();
        this.processOutput = this.output.toString();
    }
}

