/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.client.DaemonConnectionException;
import org.gradle.launcher.daemon.client.StaleDaemonAddressException;
import org.gradle.launcher.daemon.context.DaemonInstanceDetails;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.MessageIOException;
import org.gradle.messaging.remote.internal.RemoteConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonClientConnection
implements Connection<Object> {
    private static final Logger LOG = Logging.getLogger(DaemonClientConnection.class);
    private final RemoteConnection<Object> connection;
    private final DaemonInstanceDetails daemon;
    private final StaleAddressDetector staleAddressDetector;
    private boolean hasReceived;
    private final Lock dispatchLock = new ReentrantLock();

    public DaemonClientConnection(RemoteConnection<Object> connection, DaemonInstanceDetails daemon, StaleAddressDetector staleAddressDetector) {
        this.connection = connection;
        this.daemon = daemon;
        this.staleAddressDetector = staleAddressDetector;
    }

    public void requestStop() {
        LOG.debug("thread {}: requesting connection stop", Thread.currentThread().getId());
        this.connection.requestStop();
    }

    public DaemonInstanceDetails getDaemon() {
        return this.daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Object message) throws DaemonConnectionException {
        LOG.debug("thread {}: dispatching {}", Thread.currentThread().getId(), message.getClass());
        try {
            this.dispatchLock.lock();
            try {
                this.connection.dispatch(message);
            }
            finally {
                this.dispatchLock.unlock();
            }
        }
        catch (MessageIOException e) {
            LOG.debug("Problem dispatching message to the daemon. Performing 'on failure' operation...");
            if (!this.hasReceived && this.staleAddressDetector.maybeStaleAddress((Exception)((Object)e))) {
                throw new StaleDaemonAddressException("Could not dispatch a message to the daemon.", e);
            }
            throw new DaemonConnectionException("Could not dispatch a message to the daemon.", e);
        }
    }

    @Nullable
    public Object receive() throws DaemonConnectionException {
        try {
            Object object = this.connection.receive();
            return object;
        }
        catch (MessageIOException e) {
            LOG.debug("Problem receiving message to the daemon. Performing 'on failure' operation...");
            if (!this.hasReceived && this.staleAddressDetector.maybeStaleAddress((Exception)((Object)e))) {
                throw new StaleDaemonAddressException("Could not receive a message from the daemon.", e);
            }
            throw new DaemonConnectionException("Could not receive a message from the daemon.", e);
        }
        finally {
            this.hasReceived = true;
        }
    }

    public void stop() {
        LOG.debug("thread {}: connection stop", Thread.currentThread().getId());
        this.connection.stop();
    }

    static interface StaleAddressDetector {
        public boolean maybeStaleAddress(Exception var1);
    }
}

