/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import org.gradle.api.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.io.TextStream;
import org.gradle.launcher.daemon.client.InputForwarder;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.IoCommand;
import org.gradle.messaging.dispatch.Dispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonClientInputForwarder
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DaemonClientInputForwarder.class);
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final InputForwarder forwarder;

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super IoCommand> dispatch, ExecutorFactory executorFactory, IdGenerator<?> idGenerator) {
        this(inputStream, dispatch, executorFactory, idGenerator, 1024);
    }

    public DaemonClientInputForwarder(InputStream inputStream, Dispatch<? super IoCommand> dispatch, ExecutorFactory executorFactory, IdGenerator<?> idGenerator, int bufferSize) {
        ForwardTextStreamToConnection handler = new ForwardTextStreamToConnection(dispatch, idGenerator);
        this.forwarder = new InputForwarder(inputStream, handler, executorFactory, bufferSize);
    }

    public void start() {
        this.forwarder.start();
    }

    @Override
    public void stop() {
        this.forwarder.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardTextStreamToConnection
    implements TextStream {
        private final Dispatch<? super IoCommand> dispatch;
        private final IdGenerator<?> idGenerator;

        public ForwardTextStreamToConnection(Dispatch<? super IoCommand> dispatch, IdGenerator<?> idGenerator) {
            this.dispatch = dispatch;
            this.idGenerator = idGenerator;
        }

        @Override
        public void text(String input) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Forwarding input to daemon: '{}'", input.replace("\n", "\\n"));
            }
            this.dispatch.dispatch((Object)new ForwardInput(this.idGenerator.generateId(), input.getBytes()));
        }

        @Override
        public void endOfStream(@Nullable Throwable failure) {
            CloseInput message = new CloseInput(this.idGenerator.generateId());
            LOGGER.debug("Dispatching close input message: {}", message);
            this.dispatch.dispatch((Object)message);
        }
    }
}

