/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.List;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnectionException;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonInstanceDetails;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.messaging.remote.internal.ConnectException;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.RemoteConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonConnector
implements DaemonConnector {
    private static final Logger LOGGER = Logging.getLogger(DefaultDaemonConnector.class);
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private final DaemonRegistry daemonRegistry;
    protected final OutgoingConnector connector;
    private final DaemonStarter daemonStarter;
    private long connectTimeout = 30000L;

    public DefaultDaemonConnector(DaemonRegistry daemonRegistry, OutgoingConnector connector, DaemonStarter daemonStarter) {
        this.daemonRegistry = daemonRegistry;
        this.connector = connector;
        this.daemonStarter = daemonStarter;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public DaemonRegistry getDaemonRegistry() {
        return this.daemonRegistry;
    }

    @Override
    public DaemonClientConnection maybeConnect(ExplainingSpec<DaemonContext> constraint) {
        return this.findConnection(this.daemonRegistry.getAll(), constraint);
    }

    @Override
    public DaemonClientConnection maybeConnect(DaemonInstanceDetails daemon) {
        try {
            return this.connectToDaemon(daemon, new CleanupOnStaleAddress(daemon, true));
        }
        catch (ConnectException e) {
            LOGGER.debug("Cannot connect to daemon {} due to {}. Ignoring.", daemon, (Object)e);
            return null;
        }
    }

    @Override
    public DaemonClientConnection connect(ExplainingSpec<DaemonContext> constraint) {
        DaemonClientConnection connection = this.findConnection(this.daemonRegistry.getIdle(), constraint);
        if (connection != null) {
            return connection;
        }
        return this.startDaemon(constraint);
    }

    private DaemonClientConnection findConnection(List<DaemonInfo> daemons, ExplainingSpec<DaemonContext> constraint) {
        for (DaemonInfo daemon : daemons) {
            if (!constraint.isSatisfiedBy(daemon.getContext())) {
                LOGGER.debug("Found daemon {} however its context does not match the desired criteria.\n" + constraint.whyUnsatisfied(daemon.getContext()) + "\n" + "  Looking for a different daemon...", daemon);
                continue;
            }
            try {
                return this.connectToDaemon(daemon, new CleanupOnStaleAddress(daemon, true));
            }
            catch (ConnectException e) {
                LOGGER.debug("Cannot connect to daemon {} due to {}. Trying a different daemon...", daemon, (Object)e);
            }
        }
        return null;
    }

    @Override
    public DaemonClientConnection startDaemon(ExplainingSpec<DaemonContext> constraint) {
        LOGGER.info("Starting Gradle daemon");
        DaemonStartupInfo startupInfo = this.daemonStarter.startDaemon();
        LOGGER.debug("Started Gradle daemon {}", startupInfo);
        long expiry = System.currentTimeMillis() + this.connectTimeout;
        do {
            DaemonClientConnection daemonConnection;
            if ((daemonConnection = this.connectToDaemonWithId(startupInfo, constraint)) != null) {
                return daemonConnection;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        } while (System.currentTimeMillis() < expiry);
        throw new DaemonConnectionException("Timeout waiting to connect to the Gradle daemon.\n" + startupInfo.describe());
    }

    private DaemonClientConnection connectToDaemonWithId(DaemonStartupInfo daemon, ExplainingSpec<DaemonContext> constraint) throws ConnectException {
        for (DaemonInfo daemonInfo : this.daemonRegistry.getBusy()) {
            if (!daemonInfo.getUid().equals(daemon.getUid())) continue;
            try {
                if (!constraint.isSatisfiedBy(daemonInfo.getContext())) {
                    throw new DaemonConnectionException("The newly created daemon process has a different context than expected.\nIt won't be possible to reconnect to this daemon. Context mismatch: \n" + constraint.whyUnsatisfied(daemonInfo.getContext()));
                }
                return this.connectToDaemon(daemonInfo, new CleanupOnStaleAddress(daemonInfo, false));
            }
            catch (ConnectException e) {
                throw new DaemonConnectionException("Could not connect to the Gradle daemon.\n" + daemon.describe(), e);
            }
        }
        return null;
    }

    private DaemonClientConnection connectToDaemon(DaemonInstanceDetails daemon, DaemonClientConnection.StaleAddressDetector staleAddressDetector) throws ConnectException {
        RemoteConnection connection;
        try {
            connection = this.connector.connect(daemon.getAddress()).create(this.getClass().getClassLoader());
        }
        catch (ConnectException e) {
            staleAddressDetector.maybeStaleAddress((Exception)((Object)e));
            throw e;
        }
        return new DaemonClientConnection((RemoteConnection<Object>)connection, daemon, staleAddressDetector);
    }

    private class CleanupOnStaleAddress
    implements DaemonClientConnection.StaleAddressDetector {
        private final DaemonInstanceDetails daemon;
        private final boolean exposeAsStale;

        public CleanupOnStaleAddress(DaemonInstanceDetails daemon, boolean exposeAsStale) {
            this.daemon = daemon;
            this.exposeAsStale = exposeAsStale;
        }

        public boolean maybeStaleAddress(Exception failure) {
            LOGGER.info("Removing daemon from the registry due to communication failure. Daemon information: " + this.daemon);
            DefaultDaemonConnector.this.daemonRegistry.remove(this.daemon.getAddress());
            return this.exposeAsStale;
        }
    }
}

