/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.internal.specs.ExplainingSpecs;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildAction;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.protocol.BuildAndStop;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.logging.internal.OutputEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleUseDaemonClient
extends DaemonClient {
    public static final String MESSAGE = "To honour the JVM settings for this build a new JVM will be forked.";
    private static final Logger LOGGER = Logging.getLogger(SingleUseDaemonClient.class);
    private final DocumentationRegistry documentationRegistry;

    public SingleUseDaemonClient(DaemonConnector connector, OutputEventListener outputEventListener, ExplainingSpec<DaemonContext> compatibilitySpec, InputStream buildStandardInput, ExecutorFactory executorFactory, IdGenerator<?> idGenerator, DocumentationRegistry documentationRegistry) {
        super(connector, outputEventListener, compatibilitySpec, buildStandardInput, executorFactory, idGenerator);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public <T> T execute(BuildAction<T> action, BuildCancellationToken cancellationToken, BuildActionParameters parameters) {
        LOGGER.lifecycle("{} Please consider using the daemon: {}.", MESSAGE, this.documentationRegistry.getDocumentationFor("gradle_daemon"));
        BuildAndStop build = new BuildAndStop(this.getIdGenerator().generateId(), action, parameters);
        DaemonClientConnection daemonConnection = this.getConnector().startDaemon(ExplainingSpecs.<DaemonContext>satisfyAll());
        return (T)this.executeBuild(build, daemonConnection, cancellationToken);
    }
}

