/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.messaging.remote.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedDaemonRegistry
implements DaemonRegistry {
    private final Map<Address, DaemonInfo> daemonInfos = new ConcurrentHashMap<Address, DaemonInfo>();
    private final Spec<DaemonInfo> allSpec = new Spec<DaemonInfo>(){

        @Override
        public boolean isSatisfiedBy(DaemonInfo entry) {
            return true;
        }
    };
    private final Spec<DaemonInfo> idleSpec = Specs.and(this.allSpec, new Spec<DaemonInfo>(){

        @Override
        public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
            return daemonInfo.isIdle();
        }
    });
    private final Spec<DaemonInfo> busySpec = Specs.and(this.allSpec, new Spec<DaemonInfo>(){

        @Override
        public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
            return !daemonInfo.isIdle();
        }
    });

    @Override
    public List<DaemonInfo> getAll() {
        return this.daemonInfosOfEntriesMatching(this.allSpec);
    }

    @Override
    public List<DaemonInfo> getIdle() {
        return this.daemonInfosOfEntriesMatching(this.idleSpec);
    }

    @Override
    public List<DaemonInfo> getBusy() {
        return this.daemonInfosOfEntriesMatching(this.busySpec);
    }

    @Override
    public void store(Address address, DaemonContext daemonContext, String password, boolean idle) {
        this.daemonInfos.put(address, new DaemonInfo(address, daemonContext, password, idle));
    }

    @Override
    public void remove(Address address) {
        this.daemonInfos.remove(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markBusy(Address address) {
        Map<Address, DaemonInfo> map = this.daemonInfos;
        synchronized (map) {
            this.daemonInfos.get(address).setIdle(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIdle(Address address) {
        Map<Address, DaemonInfo> map = this.daemonInfos;
        synchronized (map) {
            this.daemonInfos.get(address).setIdle(true);
        }
    }

    private List<DaemonInfo> daemonInfosOfEntriesMatching(Spec<DaemonInfo> spec) {
        ArrayList<DaemonInfo> matches = new ArrayList<DaemonInfo>();
        for (DaemonInfo daemonInfo : this.daemonInfos.values()) {
            if (!spec.isSatisfiedBy(daemonInfo)) continue;
            matches.add(daemonInfo);
        }
        return matches;
    }
}

