/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import org.gradle.internal.concurrent.Synchronizer;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.messaging.remote.internal.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedDispatchConnection<T>
implements Connection<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizedDispatchConnection.class);
    private final Synchronizer sync = new Synchronizer();
    private final Connection<T> delegate;

    public SynchronizedDispatchConnection(Connection<T> delegate) {
        this.delegate = delegate;
    }

    public void requestStop() {
        LOGGER.debug("thread {}: requesting stop for connection", (Object)Thread.currentThread().getId());
        this.delegate.requestStop();
    }

    public void dispatch(final T message) {
        if (!(message instanceof OutputEvent)) {
            LOGGER.debug("thread {}: dispatching {}", (Object)Thread.currentThread().getId(), message.getClass());
        }
        this.sync.synchronize(new Runnable(){

            public void run() {
                SynchronizedDispatchConnection.this.delegate.dispatch(message);
            }
        });
    }

    public T receive() {
        Object result = this.delegate.receive();
        LOGGER.debug("thread {}: received {}", (Object)Thread.currentThread().getId(), result == null ? "null" : result.getClass());
        return (T)result;
    }

    public void stop() {
        LOGGER.debug("thread {}: stopping connection", (Object)Thread.currentThread().getId());
        this.delegate.stop();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

