/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.launcher.daemon.server.exec.DaemonCommandAction;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecution;

public class DaemonHygieneAction
implements DaemonCommandAction {
    private final long gcDelay;
    private TimeProvider timeProvider;
    private long nextGcHint;

    public DaemonHygieneAction() {
        this(120000L, new TrueTimeProvider());
    }

    DaemonHygieneAction(long gcDelay, TimeProvider timeProvider) {
        this.gcDelay = gcDelay;
        this.timeProvider = timeProvider;
    }

    public void execute(DaemonCommandExecution execution) {
        execution.proceed();
        long time = this.timeProvider.getCurrentTime();
        if (time > this.nextGcHint) {
            this.gc();
            this.nextGcHint = time + this.gcDelay;
        }
    }

    void gc() {
        System.gc();
    }
}

