/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecution;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;

class LogToClient
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(LogToClient.class);
    private final LoggingOutputInternal loggingOutput;
    private final DaemonDiagnostics diagnostics;

    public LogToClient(LoggingOutputInternal loggingOutput, DaemonDiagnostics diagnostics) {
        this.loggingOutput = loggingOutput;
        this.diagnostics = diagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBuild(final DaemonCommandExecution execution, Build build) {
        final LogLevel buildLogLevel = build.getParameters().getLogLevel();
        OutputEventListener listener = new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                try {
                    if (event.getLogLevel() != null && event.getLogLevel().compareTo(buildLogLevel) >= 0) {
                        execution.getConnection().logEvent(event);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        LOGGER.info("About to start relaying all logs to the client via the connection.");
        this.loggingOutput.addOutputEventListener(listener);
        LOGGER.info("The client will now receive all logging from the daemon (pid: " + this.diagnostics.getPid() + "). The daemon log file: " + this.diagnostics.getDaemonLog());
        try {
            execution.proceed();
        }
        finally {
            this.loggingOutput.removeOutputEventListener(listener);
        }
    }
}

