/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.CommandFailure;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.DaemonStateControl;
import org.gradle.launcher.daemon.server.exec.DaemonStoppedException;
import org.gradle.launcher.daemon.server.exec.DaemonUnavailableException;

public class StartBuildOrRespondWithBusy
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(StartBuildOrRespondWithBusy.class);
    private final DaemonDiagnostics diagnostics;

    public StartBuildOrRespondWithBusy(DaemonDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    protected void doBuild(final DaemonCommandExecution execution, final Build build) {
        DaemonStateControl stateCoordinator = execution.getDaemonStateControl();
        try {
            Runnable command = new Runnable(){

                public void run() {
                    LOGGER.info("Daemon is about to start building {}. Dispatching build started information...", build);
                    execution.getConnection().buildStarted(new BuildStarted(StartBuildOrRespondWithBusy.this.diagnostics));
                    execution.proceed();
                }
            };
            stateCoordinator.runCommand(command, execution.toString());
        }
        catch (DaemonUnavailableException e) {
            LOGGER.info("Daemon will not handle the command {} because is unavailable: {}", build, e.getMessage());
            execution.getConnection().daemonUnavailable(new DaemonUnavailable(e.getMessage()));
        }
        catch (DaemonStoppedException e) {
            execution.getConnection().completed(new CommandFailure(e));
        }
    }
}

