/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonClientGlobalServices;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;
import org.gradle.listener.ListenerManager;
import org.gradle.logging.LoggingServiceRegistry;
import org.gradle.logging.internal.OutputEventRenderer;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.provider.ClassLoaderCache;
import org.gradle.tooling.internal.provider.ClasspathInferer;
import org.gradle.tooling.internal.provider.ClientSidePayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.ClientSidePayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.DefaultPayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.ModelClassLoaderFactory;
import org.gradle.tooling.internal.provider.PayloadSerializer;
import org.gradle.tooling.internal.provider.ProviderConnection;
import org.gradle.tooling.internal.provider.ShutdownCoordinator;

public class ConnectionScopeServices {
    private final LoggingServiceRegistry loggingServices;

    public ConnectionScopeServices(LoggingServiceRegistry loggingServices) {
        this.loggingServices = loggingServices;
    }

    void configure(ServiceRegistration serviceRegistration) {
        serviceRegistration.add(LoggingServiceRegistry.class, this.loggingServices);
        serviceRegistration.addProvider(new GlobalScopeServices(false));
        serviceRegistration.addProvider(new DaemonClientGlobalServices());
    }

    ShutdownCoordinator createShutdownCoordinator(ListenerManager listenerManager, DaemonClientFactory daemonClientFactory, OutputEventRenderer outputEventRenderer) {
        ShutdownCoordinator shutdownCoordinator = new ShutdownCoordinator(daemonClientFactory, outputEventRenderer);
        listenerManager.addListener(shutdownCoordinator);
        return shutdownCoordinator;
    }

    ProviderConnection createProviderConnection(GradleLauncherFactory gradleLauncherFactory, DaemonClientFactory daemonClientFactory, ClassLoaderFactory classLoaderFactory, ClassLoaderCache classLoaderCache, ShutdownCoordinator shutdownCoordinator) {
        return new ProviderConnection(this.loggingServices, daemonClientFactory, new InProcessBuildActionExecuter(gradleLauncherFactory), new PayloadSerializer(new ClientSidePayloadClassLoaderRegistry(new DefaultPayloadClassLoaderRegistry(new ClassLoaderCache(), new ClientSidePayloadClassLoaderFactory(new ModelClassLoaderFactory(classLoaderFactory))), new ClasspathInferer())));
    }

    ProtocolToModelAdapter createProtocolToModelAdapter() {
        return new ProtocolToModelAdapter();
    }
}

