/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.model.internal.ProjectSensitiveToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultBuildController
implements InternalBuildController {
    private final GradleInternal gradle;

    public DefaultBuildController(GradleInternal gradle) {
        this.gradle = gradle;
    }

    public BuildResult<?> getBuildModel() throws BuildExceptionVersion1 {
        return new ProviderBuildResult<GradleInternal>(this.gradle);
    }

    public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        ToolingModelBuilder builder;
        boolean isImplicitProject;
        ProjectInternal project;
        BuildCancellationToken cancellationToken = this.gradle.getServices().get(BuildCancellationToken.class);
        if (cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException(String.format("Could not build '%s' model. Build cancelled.", modelIdentifier.getName()));
        }
        if (target == null) {
            project = this.gradle.getDefaultProject();
            isImplicitProject = true;
        } else if (target instanceof GradleProjectIdentity) {
            GradleProjectIdentity gradleProject = (GradleProjectIdentity)target;
            project = this.gradle.getRootProject().project(gradleProject.getPath());
            isImplicitProject = false;
        } else {
            throw new IllegalArgumentException("Don't know how to build models for " + target);
        }
        ToolingModelBuilderRegistry modelBuilderRegistry = project.getServices().get(ToolingModelBuilderRegistry.class);
        try {
            builder = modelBuilderRegistry.getBuilder(modelIdentifier.getName());
        }
        catch (UnknownModelException e) {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
        }
        Object model = builder instanceof ProjectSensitiveToolingModelBuilder ? ((ProjectSensitiveToolingModelBuilder)builder).buildAll(modelIdentifier.getName(), (Project)project, isImplicitProject) : builder.buildAll(modelIdentifier.getName(), project);
        return new ProviderBuildResult<Object>(model);
    }
}

