/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.sonar.runner.plugins;

import com.beust.jcommander.internal.Maps;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.jvm.Jvm;
import org.gradle.listener.ActionBroadcast;
import org.gradle.sonar.runner.SonarProperties;
import org.gradle.sonar.runner.SonarRunnerExtension;
import org.gradle.sonar.runner.SonarRunnerRootExtension;
import org.gradle.sonar.runner.tasks.SonarRunner;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class SonarRunnerPlugin
implements Plugin<Project> {
    private static final Predicate<File> FILE_EXISTS = new Predicate<File>(){

        public boolean apply(File input) {
            return input.exists();
        }
    };
    private static final Predicate<File> IS_DIRECTORY = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isDirectory();
        }
    };
    private static final Predicate<File> IS_FILE = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isFile();
        }
    };
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private Project targetProject;

    public void apply(Project project) {
        this.targetProject = project;
        final Map actionBroadcastMap = Maps.newHashMap();
        SonarRunner sonarRunnerTask = this.createTask(project, actionBroadcastMap);
        ActionBroadcast<SonarProperties> actionBroadcast = this.addBroadcaster(actionBroadcastMap, project);
        project.subprojects((Action)new Action<Project>(){

            public void execute(Project project) {
                ActionBroadcast actionBroadcast = SonarRunnerPlugin.this.addBroadcaster(actionBroadcastMap, project);
                project.getExtensions().create("sonarRunner", SonarRunnerExtension.class, new Object[]{actionBroadcast});
            }
        });
        SonarRunnerRootExtension rootExtension = (SonarRunnerRootExtension)project.getExtensions().create("sonarRunner", SonarRunnerRootExtension.class, new Object[]{actionBroadcast});
        this.addConfiguration(project, rootExtension);
        rootExtension.setForkOptions(sonarRunnerTask.getForkOptions());
    }

    private ActionBroadcast<SonarProperties> addBroadcaster(Map<Project, ActionBroadcast<SonarProperties>> actionBroadcastMap, Project project) {
        ActionBroadcast actionBroadcast = new ActionBroadcast();
        actionBroadcastMap.put(project, (ActionBroadcast<SonarProperties>)actionBroadcast);
        return actionBroadcast;
    }

    private SonarRunner createTask(final Project project, final Map<Project, ActionBroadcast<SonarProperties>> actionBroadcastMap) {
        SonarRunner sonarRunnerTask = (SonarRunner)project.getTasks().create("sonarRunner", SonarRunner.class);
        sonarRunnerTask.setDescription("Analyzes " + project + " and its subprojects with Sonar Runner.");
        ConventionMapping conventionMapping = new DslObject((Object)sonarRunnerTask).getConventionMapping();
        conventionMapping.map("sonarProperties", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Map properties = Maps.newLinkedHashMap();
                SonarRunnerPlugin.this.computeSonarProperties(project, properties, actionBroadcastMap);
                return properties;
            }
        });
        sonarRunnerTask.dependsOn(new Object[]{new Callable<Iterable<? extends Task>>(){

            @Override
            public Iterable<? extends Task> call() throws Exception {
                Iterable applicableProjects = Iterables.filter((Iterable)project.getAllprojects(), (Predicate)new Predicate<Project>(){

                    public boolean apply(Project input) {
                        return input.getPlugins().hasPlugin(JavaPlugin.class) && !((SonarRunnerExtension)input.getExtensions().getByType(SonarRunnerExtension.class)).isSkipProject();
                    }
                });
                return Iterables.transform((Iterable)applicableProjects, (Function)new Function<Project, Task>(){

                    @Nullable
                    public Task apply(Project input) {
                        return input.getTasks().getByName("test");
                    }
                });
            }
        }});
        return sonarRunnerTask;
    }

    public void computeSonarProperties(Project project, Map<String, Object> properties, Map<Project, ActionBroadcast<SonarProperties>> sonarPropertiesActionBroadcastMap) {
        String projectPrefix;
        SonarRunnerExtension extension = (SonarRunnerExtension)project.getExtensions().getByType(SonarRunnerExtension.class);
        if (extension.isSkipProject()) {
            return;
        }
        Map rawProperties = Maps.newLinkedHashMap();
        this.addGradleDefaults(project, rawProperties);
        SonarRunnerPlugin.evaluateSonarPropertiesBlocks(sonarPropertiesActionBroadcastMap.get(project), rawProperties);
        if (project.equals(this.targetProject)) {
            this.addSystemProperties(rawProperties);
        }
        if ((projectPrefix = project.getPath().substring(this.targetProject.getPath().length()).replace(":", ".")).startsWith(".")) {
            projectPrefix = projectPrefix.substring(1);
        }
        this.convertProperties(rawProperties, projectPrefix, properties);
        LinkedList enabledChildProjects = Lists.newLinkedList((Iterable)Iterables.filter(project.getChildProjects().values(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project input) {
                return !((SonarRunnerExtension)input.getExtensions().getByType(SonarRunnerExtension.class)).isSkipProject();
            }
        }));
        if (enabledChildProjects.isEmpty()) {
            return;
        }
        Collections.sort(enabledChildProjects);
        String modules = COMMA_JOINER.join(Iterables.transform((Iterable)enabledChildProjects, (Function)new Function<Project, String>(){

            public String apply(Project input) {
                return input.getName();
            }
        }));
        properties.put(this.convertKey("sonar.modules", projectPrefix), modules);
        for (Project childProject : enabledChildProjects) {
            this.computeSonarProperties(childProject, properties, sonarPropertiesActionBroadcastMap);
        }
    }

    private void addGradleDefaults(final Project project, final Map<String, Object> properties) {
        properties.put("sonar.projectName", project.getName());
        properties.put("sonar.projectDescription", project.getDescription());
        properties.put("sonar.projectVersion", project.getVersion());
        properties.put("sonar.projectBaseDir", project.getProjectDir());
        properties.put("sonar.dynamicAnalysis", "reuseReports");
        if (project.equals(this.targetProject)) {
            properties.put("sonar.projectKey", this.getProjectKey(project));
            properties.put("sonar.environment.information.key", "Gradle");
            properties.put("sonar.environment.information.version", project.getGradle().getGradleVersion());
            properties.put("sonar.working.directory", new File(project.getBuildDir(), "sonar"));
        }
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
                properties.put("sonar.java.source", javaPluginConvention.getSourceCompatibility());
                properties.put("sonar.java.target", javaPluginConvention.getTargetCompatibility());
            }
        });
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet main = (SourceSet)javaPluginConvention.getSourceSets().getAt("main");
                List sourceDirectories = CollectionUtils.nonEmptyOrNull((Iterable)Iterables.filter((Iterable)main.getAllSource().getSrcDirs(), (Predicate)FILE_EXISTS));
                properties.put("sonar.sources", sourceDirectories);
                SourceSet test = (SourceSet)javaPluginConvention.getSourceSets().getAt("test");
                List testDirectories = CollectionUtils.nonEmptyOrNull((Iterable)Iterables.filter((Iterable)test.getAllSource().getSrcDirs(), (Predicate)FILE_EXISTS));
                properties.put("sonar.tests", testDirectories);
                properties.put("sonar.binaries", CollectionUtils.nonEmptyOrNull((Iterable)Iterables.filter((Iterable)main.getRuntimeClasspath(), (Predicate)IS_DIRECTORY)));
                properties.put("sonar.libraries", SonarRunnerPlugin.this.getLibraries(main));
                final Test testTask = (Test)project.getTasks().getByName("test");
                if (sourceDirectories != null || testDirectories != null) {
                    File testResultsDir = testTask.getReports().getJunitXml().getDestination();
                    testResultsDir.mkdirs();
                    properties.put("sonar.surefire.reportsPath", testResultsDir);
                    properties.put("sonar.junit.reportsPath", testResultsDir);
                }
                project.getPlugins().withType(JacocoPlugin.class, (Action)new Action<JacocoPlugin>(){

                    public void execute(JacocoPlugin jacocoPlugin) {
                        JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)testTask.getExtensions().getByType(JacocoTaskExtension.class);
                        File destinationFile = jacocoTaskExtension.getDestinationFile();
                        if (destinationFile.exists()) {
                            properties.put("sonar.jacoco.reportPath", destinationFile);
                        }
                    }
                });
            }
        });
        if (properties.get("sonar.sources") == null) {
            properties.put("sonar.sources", "");
        }
    }

    private String getProjectKey(Project project) {
        String name = project.getName();
        String group = project.getGroup().toString();
        return group.isEmpty() ? name : group + ":" + name;
    }

    private void addSystemProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("sonar.")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private Collection<File> getLibraries(SourceSet main) {
        LinkedList libraries = Lists.newLinkedList((Iterable)Iterables.filter((Iterable)main.getRuntimeClasspath(), IS_FILE));
        File runtimeJar = Jvm.current().getRuntimeJar();
        if (runtimeJar != null) {
            libraries.add(runtimeJar);
        }
        return libraries;
    }

    private void convertProperties(Map<String, Object> rawProperties, String projectPrefix, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String value = this.convertValue(entry.getValue());
            if (value == null) continue;
            properties.put(this.convertKey(entry.getKey(), projectPrefix), value);
        }
    }

    private String convertKey(String key, String projectPrefix) {
        return projectPrefix.isEmpty() ? key : projectPrefix + "." + key;
    }

    private String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            Iterable flattened = Iterables.transform((Iterable)((Iterable)value), (Function)new Function<Object, String>(){

                public String apply(Object input) {
                    return SonarRunnerPlugin.this.convertValue(input);
                }
            });
            Iterable filtered = Iterables.filter((Iterable)flattened, (Predicate)Predicates.notNull());
            String joined = COMMA_JOINER.join(filtered);
            return joined.isEmpty() ? null : joined;
        }
        return value.toString();
    }

    private void addConfiguration(final Project project, final SonarRunnerRootExtension rootExtension) {
        final Configuration configuration = (Configuration)project.getConfigurations().create("sonarRunner");
        configuration.setVisible(false).setTransitive(false).setDescription("The SonarRunner configuration to use to run analysis").getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                DependencySet dependencies = resolvableDependencies.getDependencies();
                if (dependencies.isEmpty()) {
                    String toolVersion = rootExtension.getToolVersion();
                    DependencyHandler dependencyHandler = project.getDependencies();
                    Dependency dependency = dependencyHandler.create((Object)("org.codehaus.sonar.runner:sonar-runner-dist:" + toolVersion));
                    configuration.getDependencies().add((Object)dependency);
                }
            }
        });
    }

    private static void evaluateSonarPropertiesBlocks(ActionBroadcast<? super SonarProperties> propertiesActions, Map<String, Object> properties) {
        SonarProperties sonarProperties = new SonarProperties(properties);
        propertiesActions.execute((Object)sonarProperties);
    }
}

