/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.artifact.repository.metadata;

import java.io.File;
import org.gradle.mvn3.org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.gradle.mvn3.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.mvn3.org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.gradle.mvn3.org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.gradle.mvn3.org.codehaus.plexus.util.FileUtils;
import org.gradle.mvn3.org.sonatype.aether.RepositoryException;
import org.gradle.mvn3.org.sonatype.aether.metadata.MergeableMetadata;
import org.gradle.mvn3.org.sonatype.aether.metadata.Metadata;

public final class MetadataBridge
implements MergeableMetadata {
    private ArtifactMetadata metadata;
    private boolean merged;

    public MetadataBridge(ArtifactMetadata metadata) {
        this.metadata = metadata;
    }

    public void merge(File current, File result) throws RepositoryException {
        try {
            if (current.exists()) {
                FileUtils.copyFile((File)current, (File)result);
            }
            MetadataRepository localRepo = new MetadataRepository(result);
            this.metadata.storeInLocalRepository((ArtifactRepository)localRepo, (ArtifactRepository)localRepo);
            this.merged = true;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isMerged() {
        return this.merged;
    }

    public String getGroupId() {
        return this.emptify(this.metadata.getGroupId());
    }

    public String getArtifactId() {
        return this.metadata.storedInGroupDirectory() ? "" : this.emptify(this.metadata.getArtifactId());
    }

    public String getVersion() {
        return this.metadata.storedInArtifactVersionDirectory() ? this.emptify(this.metadata.getBaseVersion()) : "";
    }

    public String getType() {
        return this.metadata.getRemoteFilename();
    }

    private String emptify(String string) {
        return string != null ? string : "";
    }

    public File getFile() {
        return null;
    }

    public MetadataBridge setFile(File file) {
        return this;
    }

    public Metadata.Nature getNature() {
        if (this.metadata instanceof RepositoryMetadata) {
            switch (((RepositoryMetadata)this.metadata).getNature()) {
                case 3: {
                    return Metadata.Nature.RELEASE_OR_SNAPSHOT;
                }
                case 2: {
                    return Metadata.Nature.SNAPSHOT;
                }
            }
            return Metadata.Nature.RELEASE;
        }
        return Metadata.Nature.RELEASE;
    }

    static class MetadataRepository
    extends DefaultArtifactRepository {
        private File metadataFile;

        public MetadataRepository(File metadataFile) {
            super("local", "", null);
            this.metadataFile = metadataFile;
        }

        public String getBasedir() {
            return this.metadataFile.getParent();
        }

        public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
            return this.metadataFile.getName();
        }
    }
}

