/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.usability.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.mvn3.org.apache.maven.usability.plugin.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionDocumentation
implements Serializable {
    private List<Expression> expressions;
    private String modelEncoding = "UTF-8";
    private Map expressionsBySyntax;

    public void addExpression(Expression expression) {
        this.getExpressions().add(expression);
    }

    public List<Expression> getExpressions() {
        if (this.expressions == null) {
            this.expressions = new ArrayList<Expression>();
        }
        return this.expressions;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public void removeExpression(Expression expression) {
        this.getExpressions().remove(expression);
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public Map getExpressionsBySyntax() {
        if (this.expressionsBySyntax == null) {
            this.expressionsBySyntax = new HashMap();
            List<Expression> expressions = this.getExpressions();
            if (expressions != null && !expressions.isEmpty()) {
                for (Expression expr : expressions) {
                    this.expressionsBySyntax.put(expr.getSyntax(), expr);
                }
            }
        }
        return this.expressionsBySyntax;
    }

    public void flushExpressionsBySyntax() {
        this.expressionsBySyntax = null;
    }
}

