/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLanguageSourceSet
extends AbstractBuildableModelElement
implements LanguageSourceSetInternal {
    private final String name;
    private final String fullName;
    private final String displayName;
    private final SourceDirectorySet source;
    private boolean generated;
    private Task generatorTask;

    public AbstractLanguageSourceSet(String name, FunctionalSourceSet parent, String typeName, SourceDirectorySet source) {
        this.name = name;
        this.fullName = parent.getName() + StringUtils.capitalize((String)name);
        this.displayName = String.format("%s '%s:%s'", typeName, parent.getName(), name);
        this.source = source;
        super.builtBy(new Object[]{source.getBuildDependencies()});
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public void builtBy(Object ... tasks) {
        this.generated = true;
        super.builtBy(tasks);
    }

    @Override
    public void generatedBy(Task generatorTask) {
        this.generatorTask = generatorTask;
    }

    @Override
    public Task getGeneratorTask() {
        return this.generatorTask;
    }

    @Override
    public boolean getMayHaveSources() {
        return this.generated || !this.source.isEmpty();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void source(Action<? super SourceDirectorySet> config) {
        config.execute((Object)this.getSource());
    }

    @Override
    public SourceDirectorySet getSource() {
        return this.source;
    }
}

