/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.plugins;

import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageRegistration;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSourceTransformTask {
    private final LanguageRegistration<?> language;

    public CreateSourceTransformTask(LanguageRegistration<?> languageRegistration) {
        this.language = languageRegistration;
    }

    public void createCompileTasksForBinary(final TaskContainer tasks, BinarySpec binarySpec) {
        final BinarySpecInternal binary = (BinarySpecInternal)binarySpec;
        if (binary.isLegacyBinary() || !this.language.applyToBinary(binary)) {
            return;
        }
        final SourceTransformTaskConfig taskConfig = this.language.getTransformTask();
        binary.getSource().withType(this.language.getSourceSetType(), (Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet languageSourceSet) {
                LanguageSourceSetInternal sourceSet = (LanguageSourceSetInternal)languageSourceSet;
                if (sourceSet.getMayHaveSources()) {
                    String taskName = binary.getNamingScheme().getTaskName(taskConfig.getTaskPrefix(), sourceSet.getFullName());
                    Task task = tasks.create(taskName, taskConfig.getTaskType());
                    taskConfig.configureTask(task, binary, sourceSet);
                    task.dependsOn(new Object[]{sourceSet});
                    binary.getTasks().add(task);
                }
            }
        });
    }
}

