/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.util.Iterator;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultLanguageRegistry;
import org.gradle.language.base.internal.LanguageRegistration;
import org.gradle.language.base.internal.LanguageRegistry;
import org.gradle.language.base.internal.plugins.CreateSourceTransformTask;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.PolymorphicDomainObjectContainerModelProjection;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecContainer;
import org.gradle.platform.base.internal.DefaultPlatformContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ComponentModelBasePlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;
    private final ModelRegistry modelRegistry;

    @Inject
    public ComponentModelBasePlugin(Instantiator instantiator, ModelRegistry modelRegistry) {
        this.instantiator = instantiator;
        this.modelRegistry = modelRegistry;
    }

    public void apply(ProjectInternal project) {
        project.getPlugins().apply(LanguageBasePlugin.class);
        LanguageRegistry languageRegistry = (LanguageRegistry)project.getExtensions().create("languages", DefaultLanguageRegistry.class, new Object[0]);
        ProjectSourceSet sources = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        DefaultComponentSpecContainer components = (DefaultComponentSpecContainer)project.getExtensions().create("componentSpecs", DefaultComponentSpecContainer.class, new Object[]{this.instantiator});
        this.modelRegistry.create(ModelCreators.of((ModelReference)ModelReference.of((String)"componentSpecs", DefaultComponentSpecContainer.class), (Object)components).simpleDescriptor("Project.<init>.componentSpecs()").withProjection((ModelProjection)new PolymorphicDomainObjectContainerModelProjection((PolymorphicDomainObjectContainerInternal)components, ComponentSpec.class)).build());
        this.createLanguageSourceSets(sources, components, languageRegistry, project.getFileResolver());
    }

    private void createLanguageSourceSets(final ProjectSourceSet sources, final ComponentSpecContainer components, LanguageRegistry languageRegistry, final FileResolver fileResolver) {
        languageRegistry.all(new Action<LanguageRegistration<?>>(){

            public void execute(LanguageRegistration<?> languageRegistration) {
                ComponentModelBasePlugin.this.registerLanguageSourceSetFactory(languageRegistration, sources, fileResolver);
                ComponentModelBasePlugin.this.createDefaultSourceSetForComponents(languageRegistration, components);
            }
        });
    }

    private <U extends LanguageSourceSet> void createDefaultSourceSetForComponents(final LanguageRegistration<U> languageRegistration, ComponentSpecContainer components) {
        components.withType(ComponentSpecInternal.class).all((Action)new Action<ComponentSpecInternal>(){

            public void execute(ComponentSpecInternal componentSpecInternal) {
                FunctionalSourceSet functionalSourceSet = componentSpecInternal.getMainSource();
                if (componentSpecInternal.getInputTypes().contains(languageRegistration.getOutputType())) {
                    functionalSourceSet.maybeCreate(languageRegistration.getName(), languageRegistration.getSourceSetType());
                }
            }
        });
    }

    private <U extends LanguageSourceSet> void registerLanguageSourceSetFactory(final LanguageRegistration<U> languageRegistration, ProjectSourceSet sources, final FileResolver fileResolver) {
        sources.all((Action)new Action<FunctionalSourceSet>(){

            public void execute(final FunctionalSourceSet functionalSourceSet) {
                NamedDomainObjectFactory namedDomainObjectFactory = new NamedDomainObjectFactory<U>(){

                    public U create(String name) {
                        Class sourceSetImplementation = languageRegistration.getSourceSetImplementation();
                        return (LanguageSourceSet)ComponentModelBasePlugin.this.instantiator.newInstance(sourceSetImplementation, new Object[]{name, functionalSourceSet, fileResolver});
                    }
                };
                functionalSourceSet.registerFactory(languageRegistration.getSourceSetType(), namedDomainObjectFactory);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RuleSource
    static class Rules {
        Rules() {
        }

        @Model
        LanguageRegistry languages(ExtensionContainer extensions) {
            return (LanguageRegistry)extensions.getByType(LanguageRegistry.class);
        }

        @Mutate
        void closeComponentsForBinaries(CollectionBuilder<Task> tasks, ComponentSpecContainer components) {
        }

        @Finalize
        void createSourceTransformTasks(TaskContainer tasks, BinaryContainer binaries, LanguageRegistry languageRegistry) {
            Iterator i$ = languageRegistry.iterator();
            while (i$.hasNext()) {
                LanguageRegistration language = (LanguageRegistration)i$.next();
                for (BinarySpecInternal binary : binaries.withType(BinarySpecInternal.class)) {
                    CreateSourceTransformTask createRule = new CreateSourceTransformTask(language);
                    createRule.createCompileTasksForBinary(tasks, binary);
                }
            }
        }

        @Finalize
        void applyDefaultSourceConventions(ProjectSourceSet sources) {
            Iterator i$ = sources.iterator();
            while (i$.hasNext()) {
                FunctionalSourceSet functionalSourceSet = (FunctionalSourceSet)i$.next();
                Iterator i$2 = functionalSourceSet.iterator();
                while (i$2.hasNext()) {
                    LanguageSourceSet languageSourceSet = (LanguageSourceSet)i$2.next();
                    if (!languageSourceSet.getSource().getSrcDirs().isEmpty()) continue;
                    languageSourceSet.getSource().srcDir((Object)String.format("src/%s/%s", functionalSourceSet.getName(), languageSourceSet.getName()));
                }
            }
        }

        @Mutate
        void closeSourcesForBinaries(BinaryContainer binaries, ProjectSourceSet sources) {
        }

        @Model
        PlatformContainer platforms(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformContainer)instantiator.newInstance(DefaultPlatformContainer.class, new Object[]{Platform.class, instantiator});
        }

        @Mutate
        void registerPlatformExtension(ExtensionContainer extensions, PlatformContainer platforms) {
            extensions.add("platforms", (Object)platforms);
        }
    }
}

