/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultProjectSourceSet;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.PolymorphicDomainObjectContainerModelProjection;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LanguageBasePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private ModelRegistry modelRegistry;

    @Inject
    public LanguageBasePlugin(Instantiator instantiator, ModelRegistry modelRegistry) {
        this.instantiator = instantiator;
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project target) {
        target.getPlugins().apply(LifecycleBasePlugin.class);
        target.getExtensions().create("sources", DefaultProjectSourceSet.class, new Object[]{this.instantiator});
        DefaultBinaryContainer binaries = (DefaultBinaryContainer)target.getExtensions().create("binaries", DefaultBinaryContainer.class, new Object[]{this.instantiator});
        this.modelRegistry.create(ModelCreators.of((ModelReference)ModelReference.of((String)"binaries", BinaryContainer.class), (Object)binaries).simpleDescriptor("Project.<init>.binaries()").withProjection((ModelProjection)new PolymorphicDomainObjectContainerModelProjection((PolymorphicDomainObjectContainerInternal)binaries, BinarySpec.class)).build());
    }

    @RuleSource
    static class Rules {
        Rules() {
        }

        @Model
        ProjectSourceSet sources(ExtensionContainer extensions) {
            return (ProjectSourceSet)extensions.getByType(ProjectSourceSet.class);
        }

        @Mutate
        void createLifecycleTaskForBinary(TaskContainer tasks, BinaryContainer binaries) {
            Task assembleTask = tasks.getByName("assemble");
            for (BinarySpecInternal binary : binaries.withType(BinarySpecInternal.class)) {
                if (binary.isLegacyBinary()) continue;
                Task binaryLifecycleTask = tasks.create(binary.getNamingScheme().getLifecycleTaskName());
                binaryLifecycleTask.setGroup("build");
                binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
                binary.setBuildTask(binaryLifecycleTask);
                if (!binary.isBuildable()) continue;
                assembleTask.dependsOn(new Object[]{binary});
            }
        }
    }
}

