/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.tasks.Delete;
import org.gradle.language.base.internal.plugins.CleanRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LifecycleBasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String BUILD_GROUP = "build";

    public void apply(Project project) {
        this.addClean(project);
        this.addCleanRule(project);
        this.addAssemble(project);
    }

    private void addClean(final Project project) {
        Delete clean = (Delete)project.getTasks().create(CLEAN_TASK_NAME, Delete.class);
        clean.setDescription("Deletes the build directory.");
        clean.setGroup(BUILD_GROUP);
        clean.delete(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.getBuildDir();
            }
        }});
    }

    private void addCleanRule(Project project) {
        project.getTasks().addRule((Rule)new CleanRule(project.getTasks()));
    }

    private void addAssemble(Project project) {
        Task assembleTask = project.getTasks().create(ASSEMBLE_TASK_NAME);
        assembleTask.setDescription("Assembles the outputs of this project.");
        assembleTask.setGroup(BUILD_GROUP);
    }
}

