/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.binary;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class BaseBinarySpec
extends AbstractBuildableModelElement
implements BinarySpecInternal {
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private static ThreadLocal<BinaryInfo> nextBinaryInfo = new ThreadLocal();
    private final BinaryTasksCollection tasks = new DefaultBinaryTasksCollection(this);
    private final BinaryNamingScheme namingScheme;
    private final String typeName;

    public static <T extends BaseBinarySpec> T create(Class<T> type, BinaryNamingScheme namingScheme, Instantiator instantiator) {
        if (type.equals(BaseBinarySpec.class)) {
            throw new ModelInstantiationException("Cannot create instance of abstract class BaseBinarySpec.");
        }
        nextBinaryInfo.set(new BinaryInfo(namingScheme, type.getSimpleName()));
        try {
            BaseBinarySpec baseBinarySpec = (BaseBinarySpec)instantiator.newInstance(type, new Object[0]);
            return (T)baseBinarySpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create binary of type %s", type.getSimpleName()), e.getCause());
        }
        finally {
            nextBinaryInfo.set(null);
        }
    }

    protected BaseBinarySpec() {
        this(nextBinaryInfo.get());
    }

    private BaseBinarySpec(BinaryInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseBinarySpec is not permitted. Use a BinaryTypeBuilder instead.");
        }
        this.typeName = info.typeName;
        this.namingScheme = info.namingScheme;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s: '%s'", this.typeName, this.getName());
    }

    @Override
    public boolean isBuildable() {
        return true;
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    @Override
    public void source(Object source) {
        this.sourceSets.source(source);
    }

    @Override
    public BinaryTasksCollection getTasks() {
        return this.tasks;
    }

    public String getName() {
        return this.namingScheme.getLifecycleTaskName();
    }

    @Override
    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public boolean isLegacyBinary() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static class BinaryInfo {
        final BinaryNamingScheme namingScheme;
        final String typeName;

        private BinaryInfo(BinaryNamingScheme namingScheme, String typeName) {
            this.namingScheme = namingScheme;
            this.typeName = typeName;
        }
    }
}

