/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.component;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.ModelInstantiationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class BaseComponentSpec
implements ComponentSpec {
    private static ThreadLocal<ComponentInfo> nextComponentInfo = new ThreadLocal();
    private final FunctionalSourceSet mainSourceSet;
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private final ComponentSpecIdentifier identifier;
    private final String typeName;
    private final DomainObjectSet<BinarySpec> binaries = new DefaultDomainObjectSet(BinarySpec.class);

    public static <T extends BaseComponentSpec> T create(Class<T> type, ComponentSpecIdentifier identifier, FunctionalSourceSet mainSourceSet, Instantiator instantiator) {
        if (type.equals(BaseComponentSpec.class)) {
            throw new ModelInstantiationException("Cannot create instance of abstract class BaseComponentSpec.");
        }
        nextComponentInfo.set(new ComponentInfo(identifier, type.getSimpleName(), mainSourceSet));
        try {
            BaseComponentSpec baseComponentSpec = (BaseComponentSpec)instantiator.newInstance(type, new Object[0]);
            return (T)baseComponentSpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create component of type %s", type.getSimpleName()), e.getCause());
        }
        finally {
            nextComponentInfo.set(null);
        }
    }

    protected BaseComponentSpec() {
        this(nextComponentInfo.get());
    }

    private BaseComponentSpec(ComponentInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseComponentSpec is not permitted. Use a ComponentTypeBuilder instead.");
        }
        this.identifier = info.componentIdentifier;
        this.typeName = info.typeName;
        this.mainSourceSet = info.sourceSets;
        this.sourceSets.addMainSources(this.mainSourceSet);
    }

    public String getName() {
        return this.identifier.getName();
    }

    @Override
    public String getProjectPath() {
        return this.identifier.getProjectPath();
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s'", this.typeName, this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    @Override
    public void source(Object sources) {
        this.sourceSets.source(sources);
    }

    @Override
    public DomainObjectSet<BinarySpec> getBinaries() {
        return this.binaries;
    }

    public FunctionalSourceSet getMainSource() {
        return this.mainSourceSet;
    }

    private static class ComponentInfo {
        final ComponentSpecIdentifier componentIdentifier;
        final String typeName;
        final FunctionalSourceSet sourceSets;

        private ComponentInfo(ComponentSpecIdentifier componentIdentifier, String typeName, FunctionalSourceSet sourceSets) {
            this.componentIdentifier = componentIdentifier;
            this.typeName = typeName;
            this.sourceSets = sourceSets;
        }
    }
}

