/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedElementSelector<T extends Named>
implements Transformer<List<T>, NamedDomainObjectContainer<? super T>> {
    private final Class<T> type;
    private final List<String> names;

    NamedElementSelector(Class<T> type, List<String> names) {
        this.type = type;
        this.names = names;
    }

    public List<T> transform(NamedDomainObjectContainer<? super T> ts) {
        NamedDomainObjectSet allWithType = ts.withType(this.type);
        if (this.names.isEmpty()) {
            return Lists.newArrayList((Iterable)allWithType);
        }
        ArrayList matching = Lists.newArrayList();
        final ArrayList notFound = Lists.newArrayList(this.names);
        CollectionUtils.filter((Iterable)allWithType, (Collection)matching, (Spec)new Spec<T>(){

            public boolean isSatisfiedBy(T element) {
                return notFound.remove(element.getName());
            }
        });
        if (notFound.size() == 1) {
            throw new InvalidUserDataException(String.format("Invalid %s: %s", this.type.getSimpleName(), notFound.get(0)));
        }
        if (notFound.size() > 1) {
            throw new InvalidUserDataException(String.format("Invalid %ss: %s", this.type.getSimpleName(), notFound));
        }
        return matching;
    }
}

