/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import java.lang.annotation.Annotation;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenMethodRuleDefinitionHandler;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.platform.base.InvalidComponentModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler<T extends Annotation>
extends AbstractAnnotationDrivenMethodRuleDefinitionHandler<T> {
    protected <R> void assertIsVoidMethod(MethodRuleDefinition<R> ruleDefinition) {
        if (!ModelType.of(Void.TYPE).equals((Object)ruleDefinition.getReturnType())) {
            throw new InvalidComponentModelException(String.format("%s method must not have a return value.", this.annotationType.getSimpleName()));
        }
    }

    protected <R, V> void visitCollectionBuilderSubject(RuleMethodDataCollector dataCollector, MethodRuleDefinition<R> ruleDefinition, Class<V> typeParameter) {
        if (ruleDefinition.getReferences().size() == 0) {
            throw new InvalidComponentModelException(String.format("%s method must have a parameter of type '%s'.", this.annotationType.getSimpleName(), CollectionBuilder.class.getName()));
        }
        ModelType builder = ((ModelReference)ruleDefinition.getReferences().get(0)).getType();
        if (!ModelType.of(CollectionBuilder.class).isAssignableFrom(builder)) {
            throw new InvalidComponentModelException(String.format("%s method first parameter must be of type '%s'.", this.annotationType.getSimpleName(), CollectionBuilder.class.getName()));
        }
        if (builder.getTypeVariables().size() != 1) {
            throw new InvalidComponentModelException(String.format("Parameter of type '%s' must declare a type parameter extending '%s'.", CollectionBuilder.class.getSimpleName(), typeParameter.getSimpleName()));
        }
        ModelType subType = (ModelType)builder.getTypeVariables().get(0);
        if (subType.isWildcard()) {
            throw new InvalidComponentModelException(String.format("%s type '%s' cannot be a wildcard type (i.e. cannot use ? super, ? extends etc.).", typeParameter.getName(), subType.toString()));
        }
        dataCollector.parameterTypes.put(typeParameter, subType.getConcreteClass());
    }

    protected <R, S> void visitDependency(RuleMethodDataCollector dataCollector, MethodRuleDefinition<R> ruleDefinition, ModelType<S> expectedDependency) {
        List references = ruleDefinition.getReferences();
        ModelType dependency = null;
        for (ModelReference reference : references) {
            ModelType newDependency = expectedDependency.asSubclass(reference.getType());
            if (newDependency == null) continue;
            if (dependency != null) {
                throw new InvalidComponentModelException(String.format("%s method must have one parameter extending %s. Found multiple parameter extending %s.", this.annotationType.getSimpleName(), expectedDependency.getConcreteClass().getSimpleName(), expectedDependency.getConcreteClass().getSimpleName()));
            }
            dependency = newDependency;
        }
        if (dependency == null) {
            throw new InvalidComponentModelException(String.format("%s method must have one parameter extending %s. Found no parameter extending %s.", this.annotationType.getSimpleName(), expectedDependency.getConcreteClass().getSimpleName(), expectedDependency.getConcreteClass().getSimpleName()));
        }
        dataCollector.put(expectedDependency.getConcreteClass(), dependency.getConcreteClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RuleMethodDataCollector {
        private HashMap<Class<?>, Class<?>> parameterTypes = new HashMap();

        protected RuleMethodDataCollector() {
        }

        public <S, R extends S> Class<R> getParameterType(Class<S> baseClass) {
            return this.parameterTypes.get(baseClass);
        }

        public <S> void put(Class<S> baseClass, Class<? extends S> concreteClass) {
            if (!baseClass.isAssignableFrom(concreteClass)) {
                throw new InvalidParameterException(String.format("Class %s must be assignable from Class %s", baseClass.getName(), concreteClass.getName()));
            }
            this.parameterTypes.put(baseClass, concreteClass);
        }
    }
}

