/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.collection.internal.DefaultCollectionBuilder;
import org.gradle.model.entity.internal.NamedEntityInstantiator;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.InvalidComponentModelException;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler;
import org.gradle.platform.base.internal.registry.CollectionBuilderBasedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTasksRuleDefinitionHandler
extends AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler<BinaryTasks> {
    public <R> void register(MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        this.doRegister(ruleDefinition, modelRegistry, dependencies);
    }

    private <R, S extends BinarySpec> void doRegister(MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        try {
            AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler.RuleMethodDataCollector(this);
            this.verifyMethodSignature(dataCollector, ruleDefinition);
            Class binaryType = dataCollector.getParameterType(BinarySpec.class);
            dependencies.add(ComponentModelBasePlugin.class);
            ModelReference tasks = ModelReference.of((ModelPath)ModelPath.path((String)"tasks"), (ModelType)new ModelType<TaskContainer>(){});
            modelRegistry.mutate(new BinaryTaskRule((ModelReference<TaskContainer>)tasks, binaryType, ruleDefinition, modelRegistry));
        }
        catch (InvalidComponentModelException e) {
            this.invalidModelRule(ruleDefinition, e);
        }
    }

    private <R> void verifyMethodSignature(AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler.RuleMethodDataCollector taskDataCollector, MethodRuleDefinition<R> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        this.visitCollectionBuilderSubject(taskDataCollector, ruleDefinition, Task.class);
        this.visitDependency(taskDataCollector, ruleDefinition, ModelType.of(BinarySpec.class));
    }

    protected <R> void invalidModelRule(MethodRuleDefinition<R> ruleDefinition, InvalidComponentModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(" is not a valid BinaryTask model rule method.");
        throw new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Instantiator<S extends Task>
    implements NamedEntityInstantiator<Task> {
        private final BinarySpec binarySpec;
        private final TaskContainer container;

        public Instantiator(BinarySpec binarySpec, TaskContainer container) {
            this.binarySpec = binarySpec;
            this.container = container;
        }

        public ModelType<Task> getType() {
            return ModelType.of(Task.class);
        }

        public Task create(String name) {
            Task task = this.container.create(name);
            this.binarySpec.builtBy(new Object[]{task});
            this.binarySpec.getTasks().add(task);
            return task;
        }

        public <U extends Task> U create(String name, Class<U> type) {
            Task task = this.container.create(name, type);
            this.binarySpec.builtBy(new Object[]{task});
            this.binarySpec.getTasks().add(task);
            return (U)task;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BinaryTaskRule<R, T extends BinarySpec>
    extends CollectionBuilderBasedRule<R, Task, T, TaskContainer> {
        private final ModelRegistry modelRegistry;
        private final Class<T> binaryType;

        public BinaryTaskRule(ModelReference<TaskContainer> subject, Class<T> binaryType, MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry) {
            super(subject, binaryType, ruleDefinition, ModelReference.of((String)"binaries", BinaryContainer.class));
            this.binaryType = binaryType;
            this.modelRegistry = modelRegistry;
        }

        public void mutate(TaskContainer container, Inputs inputs) {
            BinaryContainer binaries = (BinaryContainer)inputs.get(0, ModelType.of(BinaryContainer.class)).getInstance();
            for (BinarySpec binary : binaries.withType(this.binaryType)) {
                Instantiator instantiator = new Instantiator(binary, container);
                DefaultCollectionBuilder collectionBuilder = new DefaultCollectionBuilder(this.getSubject().getPath(), instantiator, (ModelRuleDescriptor)new SimpleModelRuleDescriptor("Project.<init>.tasks()"), inputs, (ModelRuleRegistrar)this.modelRegistry);
                this.invoke(inputs, collectionBuilder, binary, binaries);
            }
        }
    }
}

