/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.model.internal.core.ModelType;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.ComponentModelRuleDefinitionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTypeRuleDefinitionHandler
extends ComponentModelRuleDefinitionHandler<BinaryType, BinarySpec, BaseBinarySpec> {
    public BinaryTypeRuleDefinitionHandler(Instantiator instantiator) {
        super("binary", BinaryType.class, BinarySpec.class, BaseBinarySpec.class, BinaryTypeBuilder.class, JavaReflectionUtil.factory((Instantiator)new DirectInstantiator(), DefaultBinaryTypeBuilder.class, (Object[])new Object[0]), new RegistrationAction(instantiator));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationAction
    implements Action<ComponentModelRuleDefinitionHandler.RegistrationContext<BinarySpec, BaseBinarySpec>> {
        private final Instantiator instantiator;

        public RegistrationAction(Instantiator instantiator) {
            this.instantiator = instantiator;
        }

        public void execute(ComponentModelRuleDefinitionHandler.RegistrationContext<BinarySpec, BaseBinarySpec> context) {
            BinaryContainer binaries = (BinaryContainer)context.getExtensions().getByType(BinaryContainer.class);
            this.doRegister(binaries, context.getType(), context.getImplementation());
        }

        private <T extends BinarySpec, U extends BaseBinarySpec> void doRegister(BinaryContainer binaries, ModelType<T> type, final ModelType<U> implementation) {
            binaries.registerFactory(type.getConcreteClass(), new NamedDomainObjectFactory<T>(){

                public T create(String name) {
                    BinaryNamingScheme binaryNamingScheme = new DefaultBinaryNamingSchemeBuilder().withComponentName(name).build();
                    Object created = BaseBinarySpec.create(implementation.getConcreteClass(), binaryNamingScheme, RegistrationAction.this.instantiator);
                    return created;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultBinaryTypeBuilder
    extends AbstractTypeBuilder<BinarySpec>
    implements BinaryTypeBuilder<BinarySpec> {
        public DefaultBinaryTypeBuilder() {
            super(BinaryType.class);
        }
    }
}

