/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelMutator;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleInput;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionBuilderBasedRule<R, S, T, C>
implements ModelMutator<C> {
    private final ModelReference<C> subject;
    private final Class<? extends T> baseType;
    private final MethodRuleDefinition<R> ruleDefinition;
    private ImmutableList<ModelReference<?>> inputs;
    protected int baseTypeParameterIndex;

    public CollectionBuilderBasedRule(ModelReference<C> subject, Class<? extends T> baseType, MethodRuleDefinition<R> ruleDefinition, ModelReference<?> ... additionalInput) {
        this.subject = subject;
        this.baseType = baseType;
        this.ruleDefinition = ruleDefinition;
        this.inputs = this.calculateInputs(Arrays.asList(additionalInput));
    }

    public List<ModelReference<?>> getInputs() {
        return this.inputs;
    }

    public ModelReference<C> getSubject() {
        return this.subject;
    }

    public ModelRuleDescriptor getDescriptor() {
        return this.ruleDefinition.getDescriptor();
    }

    private ImmutableList<ModelReference<?>> calculateInputs(List<ModelReference<?>> modelReferences) {
        final List references = this.ruleDefinition.getReferences().subList(1, this.ruleDefinition.getReferences().size());
        List filteredReferences = CollectionUtils.filter(references, (Spec)new Spec<ModelReference<?>>(){

            public boolean isSatisfiedBy(ModelReference<?> element) {
                if (element.getType().equals((Object)ModelType.of((Class)CollectionBuilderBasedRule.this.baseType))) {
                    CollectionBuilderBasedRule.this.baseTypeParameterIndex = references.indexOf(element) + 1;
                    return false;
                }
                return true;
            }
        });
        ImmutableList.Builder allInputs = ImmutableList.builder();
        allInputs.addAll(modelReferences);
        allInputs.addAll((Iterable)filteredReferences);
        return allInputs.build();
    }

    protected void invoke(Inputs inputs, CollectionBuilder<S> collectionBuilder, T baseTypeParameter, Object ignoredInput) {
        Object[] args = new Object[inputs.size() + 1];
        args[0] = collectionBuilder;
        args[this.baseTypeParameterIndex] = baseTypeParameter;
        block0: for (ModelRuleInput modelRuleInput : inputs.getRuleInputs()) {
            Object instance = modelRuleInput.getView().getInstance();
            if (instance == ignoredInput) continue;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = instance;
                continue block0;
            }
        }
        this.ruleDefinition.getRuleInvoker().invoke(args);
    }
}

