/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.collection.internal.DefaultCollectionBuilder;
import org.gradle.model.entity.internal.NamedEntityInstantiator;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.InvalidComponentModelException;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler;
import org.gradle.platform.base.internal.registry.CollectionBuilderBasedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBinariesRuleDefinitionHandler
extends AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler<ComponentBinaries> {
    public <R> void register(MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        this.doRegister(ruleDefinition, modelRegistry, dependencies);
    }

    private <R, S extends BinarySpec> void doRegister(MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry, RuleSourceDependencies dependencies) {
        try {
            AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler.RuleMethodDataCollector(this);
            this.visitAndVerifyMethodSignature(dataCollector, ruleDefinition);
            Class binaryType = dataCollector.getParameterType(BinarySpec.class);
            Class componentType = dataCollector.getParameterType(ComponentSpec.class);
            dependencies.add(ComponentModelBasePlugin.class);
            ModelReference subject = ModelReference.of((ModelPath)ModelPath.path((String)"binaries"), (ModelType)new ModelType<BinaryContainer>(){});
            this.configureMutationRule(modelRegistry, (ModelReference<BinaryContainer>)subject, componentType, binaryType, ruleDefinition);
        }
        catch (InvalidComponentModelException e) {
            this.invalidModelRule(ruleDefinition, e);
        }
    }

    private <S extends BinarySpec, R> void configureMutationRule(ModelRegistry modelRegistry, ModelReference<BinaryContainer> subject, Class<? extends ComponentSpec> componentType, Class<S> binaryType, MethodRuleDefinition<R> ruleDefinition) {
        modelRegistry.mutate(new ComponentBinariesRule<R, S>(subject, componentType, binaryType, ruleDefinition, modelRegistry));
    }

    private <R> void visitAndVerifyMethodSignature(AbstractAnnotationDrivenMethodComponentRuleDefinitionHandler.RuleMethodDataCollector dataCollector, MethodRuleDefinition<R> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        this.visitCollectionBuilderSubject(dataCollector, ruleDefinition, BinarySpec.class);
        this.visitDependency(dataCollector, ruleDefinition, ModelType.of(ComponentSpec.class));
    }

    protected <R> void invalidModelRule(MethodRuleDefinition<R> ruleDefinition, InvalidComponentModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(" is not a valid ComponentBinaries model rule method.");
        throw new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Instantiator<S extends BinarySpec>
    implements NamedEntityInstantiator<S> {
        private final Class<S> binaryType;
        private final ComponentSpec componentSpec;
        private final BinaryContainer container;

        public Instantiator(Class<S> binaryType, ComponentSpec componentSpec, BinaryContainer container) {
            this.binaryType = binaryType;
            this.componentSpec = componentSpec;
            this.container = container;
        }

        public ModelType<S> getType() {
            return ModelType.of(this.binaryType);
        }

        public S create(String name) {
            BinarySpec binary = (BinarySpec)this.container.create(name, this.binaryType);
            this.componentSpec.getBinaries().add((Object)binary);
            return (S)binary;
        }

        public <U extends S> U create(String name, Class<U> type) {
            BinarySpec binary = (BinarySpec)this.container.create(name, type);
            this.componentSpec.getBinaries().add((Object)binary);
            return (U)binary;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentBinariesRule<R, S extends BinarySpec>
    extends CollectionBuilderBasedRule<R, S, ComponentSpec, BinaryContainer> {
        private final Class<? extends ComponentSpec> componentType;
        private final ModelRegistry modelRegistry;
        private final Class<S> binaryType;

        public ComponentBinariesRule(ModelReference<BinaryContainer> subject, Class<? extends ComponentSpec> componentType, Class<S> binaryType, MethodRuleDefinition<R> ruleDefinition, ModelRegistry modelRegistry) {
            super(subject, componentType, ruleDefinition, ModelReference.of((String)"componentSpecs", ComponentSpecContainer.class));
            this.componentType = componentType;
            this.binaryType = binaryType;
            this.modelRegistry = modelRegistry;
        }

        public void mutate(BinaryContainer binaries, Inputs inputs) {
            ComponentSpecContainer componentSpecs = (ComponentSpecContainer)inputs.get(0, ModelType.of(ComponentSpecContainer.class)).getInstance();
            for (ComponentSpec componentSpec : componentSpecs.withType(this.componentType)) {
                Instantiator<S> namedEntityInstantiator = new Instantiator<S>(this.binaryType, componentSpec, binaries);
                DefaultCollectionBuilder collectionBuilder = new DefaultCollectionBuilder(this.getSubject().getPath(), namedEntityInstantiator, (ModelRuleDescriptor)new SimpleModelRuleDescriptor("Project.<init>.binaries()"), inputs, (ModelRuleRegistrar)this.modelRegistry);
                this.invoke(inputs, collectionBuilder, componentSpec, componentSpecs);
            }
        }
    }
}

